/*******************************************************************************
 * Copyright (c) 2005 IBM, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Initial Java API and implementation
 *
 * $Id: Constants.cpp,v 1.9 2005/10/17 23:19:06 akaylor Exp $
 *
 *******************************************************************************/ 


#include "tptp/client/Constants.h"



		const unsigned char Constants::RA_ACKNOWLEDGEMENT_MESSAGE			=0x00000000;
		const unsigned char Constants::RA_CONTROL_MESSAGE					=0x00000001;
		const unsigned long Constants::RA_MAGIC							=0x82656780;
		const unsigned long Constants::RA_VERSION							=0x00000100;
		const unsigned long Constants::RA_AUTHENTICATE					=0x00000001;
		const unsigned long Constants::RA_LAUNCH_PROCESS					=0x00000010;
		const unsigned long Constants::RA_KILL_PROCESS					=0x0000001B;
		const unsigned long Constants::RA_QUERY_PROCESS_LIST				=0x00000011;
		const unsigned long Constants::RA_QUERY_AGENT_LIST				=0x00000012;
		const unsigned long Constants::RA_QUERY_AGENT_DETAILS				=0x0000001C;
		const unsigned long Constants::RA_REGISTER_AGENT_NOTIFICATION		=0x00000013;
		const unsigned long Constants::RA_ATTACH_TO_AGENT					=0x00000014;
		const unsigned long Constants::RA_DETACH_FROM_AGENT				=0x00000015;
		const unsigned long Constants::RA_START_MONITORING_AGENT_REMOTE	=0x00000016;
		const unsigned long Constants::RA_START_MONITORING_AGENT_LOCAL	=0x00000017;
		const unsigned long Constants::RA_STOP_MONITORING_AGENT			=0x00000018;
		const unsigned long Constants::RA_SET_NAME_VALUE_PAIR				=0x00000019;
		const unsigned long Constants::RA_GET_PROPERTY_LIST				=0x0000001E;
		const unsigned long Constants::RA_MANAGE_FILE						=0x0000001F;


		/* The extension point for custom protocol piggy-backing */
		const unsigned long Constants::RA_CUSTOM_COMMAND					=0x0000001A;
		const unsigned long Constants::RA_BINARY_CUSTOM_COMMAND			=0x0000001D;

		/* The various COMMAND_ID's from the Remoteable Agent Controller (client targeted flows) */
		const unsigned long Constants::RA_AUTHENTICATION_FAILED			=0x00000002;
		const unsigned long Constants::RA_AUTHENTICATION_SUCCESSFUL		=0x00000003;
		const unsigned long Constants::RA_SERVER_SECURITY_REQUIREMENTS	=0x00000004;
		const unsigned long Constants::RA_PROCESS_LAUNCHED				=0x00000020;
		const unsigned long Constants::RA_PROCESS_EXITED				=0x00000029;
		const unsigned long Constants::RA_PROCESS_LIST					=0x00000021;
		const unsigned long Constants::RA_AGENT_LIST					=0x00000022;
		const unsigned long Constants::RA_AGENT_ACTIVE					=0x00000023;
		const unsigned long Constants::RA_AGENT_INACTIVE				=0x00000024;
		const unsigned long Constants::RA_AGENT_DETAILS					=0x00000028;
		const unsigned long Constants::RA_ERROR_STRING					=0x00000025;
		const unsigned long Constants::RA_CONTROLLER_REQUEST_MONITOR	=0x00000062;
		const unsigned long Constants::RA_PROPERTY_LIST					=0x0000002A;

		const unsigned long Constants::RA_AGENT_QUERY_STATE				=0x0000002B; // Bug 54376
		const unsigned long Constants::RA_AGENT_ATTACHED				=0x0000002C; // Bug 54376
		const unsigned long Constants::RA_AGENT_DETACHED				=0x0000002D; // Bug 54376

		const unsigned long Constants::RA_RESOURCE_LOCATION				=0x00000070;


		const unsigned long Constants::RA_GET_AGENT						=0x00000080;
		const unsigned long Constants::RA_AGENT_ID						=0x00000081;

		/**
		* Various constants that both the client and server must adhere to.
		*/
		const unsigned int Constants::CTL_PORT_NUM_SERVER			=10002; /* hardcoded to start with */
		const unsigned int Constants::CTL_PORT_NUM_CLIENT			=10003; /* hardcoded to start with */
		const unsigned int Constants::MESSAGE_HEADER_LENGTH		=10;		/* 10 byte header to start with */
		const unsigned int Constants::MAX_MESSAGE_LENGTH			=8096;	/* The maximum size of a message */
		const unsigned int Constants::MAX_COMMAND_LINE_LENGTH		=512;	/* Maximum length of a command line string */
		const unsigned int Constants::DATA_PORT_NUM_CLIENT		=10004;
		const unsigned int Constants::MAX_DATA_LENGTH				=4096;	/* The size of the data buffer for sockets */

		/* This package is ported from C, so to facilitate sizeof code for primitives
		the following constants are provided */

		const unsigned int Constants::sizeofByte					=1;
		const unsigned int Constants::sizeofChar					=2;
		const unsigned int Constants::sizeofShort					=2;
		const unsigned int Constants::sizeofLong					=4;
		const unsigned int Constants::OLD_RAC_MESSAGE 			=1;
		const unsigned int Constants::NEW_AC_MESSAGE				=2;
		const unsigned int Constants::NEW_AC_DEFAULT_MESSAGE		=1;

		//Byte stream identifier: looks like "Tt"
		const unsigned long  Constants::AC_MAGIC_NUMBER			=0x54B674DE;

		//const unsigned long  Constants::DATA_PATH_SEND			=0x00000001;
		//const unsigned long	 Constants::DATA_PATH_RECEIVE		=0x00000002;
		//const unsigned long	 Constants::DATA_PATH_TWOWAY		=DATA_PATH_SEND | DATA_PATH_RECEIVE;
		const int	 Constants::DATA_MESSAGE_HEADER_LENGTH		= 12;


