/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: ContextMapper.cpp,v 1.2 2005/06/06 19:06:56 vnaikawadi Exp $
 *
 *******************************************************************************/ 



#include "ContextMapper.h"



using namespace TPTP::Client;



ContextMapper::ContextMapper()
{


}


ContextMapper::~ContextMapper()
{
	_map.clear();
}


void ContextMapper::addContext(long contextId, ICommandHandler* handler) 
{

	/*
	synchronized(_map) {
		if(_maxMappingCount == _map.length) {
			increaseContextmappingCapacity();
		}
		for(int i=_mappingCount; i>=0; i--) {
			if(_map[i]==null) {
				_mappingCount++;
				_maxMappingCount++;
				_map[i]=new ContextMap();
				_map[i]._context=contextId;
				_map[i]._handler=handler;
				_map[i]._dirty=true;
				return;
			}
			else if(!_map[i]._dirty) {
				_mappingCount++;
				_map[i]._context=contextId;
				_map[i]._handler=handler;
				_map[i]._dirty=true;
				return;
			}
		}
	}
	*/

	std::map<long, ContextMap*>::iterator  mapIterator = _map.find(contextId);
	if ((mapIterator == _map.end()) && (handler != NULL))
	{
		// not found, add the given pair to the table
		_maxMappingCount++;
		ContextMap* newMap = new ContextMap();
		newMap->_context=contextId;
		newMap->_handler=handler;
		newMap->_dirty=true;
		_map.insert(std::map<long, ContextMap*>::value_type(contextId, newMap));
	}
	else
	{

	}
}

ICommandHandler* ContextMapper::getHandler(long contextid) 
{
	ICommandHandler* ch = NULL;
	/*
	synchronized (_map) {
		for(int i=_maxMappingCount-1; i>=0; i--) {
			if(_map[i]== NULL) {
				// This should never happen 
				break;
			}
			if(_map[i]->_context == contextid && _map[i]._dirty == true ) {
				ch=_map[i]->_handler;
				break;
			}
		}
	}*/

	if (_map[contextid] != NULL)
	{
		ch = _map[contextid]->_handler;
	}

	return ch;
}


/*
protected void increaseContextmappingCapacity() 
{
	synchronized(_map) {
		ContextMap[] newMapper=new ContextMap[_maxMappingCount+MAPPING_INCREMENT];
		for(int i=0; i<_maxMappingCount; i++) {
			newMapper[i]=_map[i];
		}
		_map=newMapper;
		newMapper=null;
	}
}

*/

void ContextMapper::removeContext(long contextId) 
{
	/*
	synchronized (_map) {
		for(int i=_maxMappingCount-1; i>=0; i--) {
			if(_map[i]._context==contextId && _map[i]._dirty==true ) {
				_mappingCount--;
				_map[i]._dirty=false;
				_map[i]._handler=null;
				break;
			}
		}
	}
	*/

   std::map<long, ContextMap*>::iterator mapIterator = _map.find(contextId) ;

   if (mapIterator != _map.end())
   {
      // delete the pair
      _map.erase(mapIterator) ;
   }


}


