/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: ContextMapper.h,v 1.2 2005/06/01 20:17:04 vnaikawadi Exp $
 *
 *******************************************************************************/ 



#ifndef  ContextMapper_H
#define  ContextMapper_H

#include "tptp/TPTPExport.h"

#include "tptp/TPTPUtils.h"
#include "tptp/client/ICommandHandler.h"

#include <map>

using namespace std;


namespace TPTP
{

	namespace Client
	{

		class ContextMap 
		{
			public:
				long _context;
				ICommandHandler* _handler;
				bool _dirty;
		};

		class ContextMapper
		{

			private:
				static const int MAPPING_INCREMENT;

				std::map<long, ContextMap*> _map;
				int _mappingCount;
				int _maxMappingCount;

			public:
				ContextMapper();
				~ContextMapper();
				void addContext(long contextId, ICommandHandler* handler);
				ICommandHandler* getHandler(long contextid);
				void removeContext(long contextId);

			//protected:
				//void increaseContextmappingCapacity();


		};

	}

}

#endif


