/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: EnvVariable.cpp,v 1.1 2005/08/20 19:27:14 vnaikawadi Exp $
 *
 *******************************************************************************/ 


#include "tptp/client/EnvVariable.h"

using namespace TPTP::Client;

/**
* Create an environment variable with the specified name
* value pair.
*/
EnvVariable::EnvVariable(char* name, char* value) 
{
	_name = name;
	_value = value;
}

/**
* Retrieve the name of this environment variable.
*/
char* EnvVariable::getName() 
{
	return _name;
}


/**
* Set the name of this environment variable.
*/
void EnvVariable::setName(char* name) 
{
	_name = name;
}

/**
* Retrieve the value of this environment variable.
*/
char* EnvVariable::getValue() 
{
	return _value;
}

/**
* Set the value of this environment variable.
*/
void EnvVariable::setValue(char* value) 
{
	_value = value;
}


