/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Initial Java API and implementation
 *
 * $Id: GetAgentCommand.cpp,v 1.6 2009/08/26 14:59:50 jwest Exp $
 *
 *******************************************************************************/ 

#include <stdio.h>
#include "GetAgentCommand.h"
#include "tptp/client/Constants.h"
#include "tptp/client/Message.h"
 

GetAgentCommand::GetAgentCommand(string aName,unsigned int create) 
{
	this->agentName= new TPTP_String(aName);
	this->createNew = create;
	this->_tag=Constants::RA_GET_AGENT;
}

GetAgentCommand::GetAgentCommand(string aName) 
{
	createNew = 1;
	#if defined(MVS) || defined(_AIX)
		GetAgentCommand(aName,1);
	#else
		GetAgentCommand::GetAgentCommand(aName,1);
	#endif
}


void GetAgentCommand::buildCommand()
{
	string CommandBuffer = string();
	char	tempbuf[1024];
	sprintf(tempbuf, "<Cmd dest=\"%ld\" src=\"%ld\" ctxt=\"%ld\">",
			this->getDestination(), this->getSource(), this->getContext());
	CommandBuffer = CommandBuffer + tempbuf;
	//*tempbuf = NULL;
	
	sprintf(tempbuf, "<getAgent iid=\"org.eclipse.tptp.agentManager\">");
	CommandBuffer = CommandBuffer + tempbuf;
	//*tempbuf = NULL;
	
	CommandBuffer = CommandBuffer + "<agentName>" + this->agentName->getData() + "</agentName>";
	CommandBuffer = CommandBuffer + "</getAgent></Cmd>";

	this->command = new TPTP_String(CommandBuffer);

}

unsigned int GetAgentCommand::getSize()
{	
	int size = command->getSize();
	return size;
}

void GetAgentCommand::setCommandName(string cmdName)
{	
	this->commandName = new TPTP_String(cmdName);
}

string GetAgentCommand::getCommandName()	
{	
	return this->commandName->getData();
}

void GetAgentCommand::setCommandData(string cmdData)
{	
	this->commandData = new TPTP_String(cmdData);
}

string GetAgentCommand::getCommandData()
{	
	return this->commandData->getData();
}

string GetAgentCommand::getCommand()
{	
	return this->command->getData(); 
}

unsigned char* GetAgentCommand::readFromBuffer(unsigned char *buffer,unsigned int offset) 
{
	//No code in the Java Impl 
	// Java code to be cleaned up
	return buffer;
}

unsigned char* GetAgentCommand::writeToBuffer(unsigned char *buffer,unsigned int offset) 
{
	//unsigned int current=offset;
	Message::copyTPTPSTRINGToBuffer(buffer, command->getData());
	return buffer; 
}

void GetAgentCommand::parseBuffer(char *buffer)
{
	return;
}




