/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: NodeFactory.cpp,v 1.6 2006/02/10 19:54:16 vnaikawadi Exp $
 *
 *******************************************************************************/ 



#include "tptp/client/NodeFactory.h"
#include "NodeImpl.h"
#include "tptp/TPTPConfig.h"

//class NodeImpl;

using namespace TPTP::Client;

NodeList NodeFactory::_servers;

INode* NodeFactory::createNode(char* hostName)
{
	INode* newNode = 0;

	initializeXMLPlatformUtils();
	NodeList::iterator  mapIterator = NodeFactory::_servers.find(hostName);
	if ((mapIterator == NodeFactory::_servers.end()) && (hostName != NULL))
	{
		// not found, add the given pair to the table		
		newNode = new NodeImpl(hostName);
		NodeFactory::_servers.insert(NodeList::value_type(hostName, newNode));
	}
	else
	{
		return (INode*)mapIterator->second;
	}

	return newNode;

}


void NodeFactory::deleteNode(INode* node)
{
	NodeList::iterator mapIterator = NodeFactory::_servers.find(node->getName()) ;

	if (mapIterator != NodeFactory::_servers.end())
   {
		// delete the pair
		NodeFactory::_servers.erase(mapIterator) ;
   }
	delete node;
	terminateXMLPlatformUtils();
}


