/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: NodeImpl.h,v 1.7 2005/08/20 19:29:16 vnaikawadi Exp $
 *
 *******************************************************************************/



#ifndef  NodeImpl_H
#define  NodeImpl_H

#include "tptp/client/INode.h"



#include <map>


namespace TPTP
{

	namespace Client
	{

		class NodeImpl: public INode
		{
			private:
				char* _name;
				char* _addr;
				//Vector _listeners=new Vector(10);
				//IConnection* _connection;

				//AgentControllerProxy* _ac;

				std::map<int, AgentController*> _acList;


			public:

				NodeImpl();

				NodeImpl(char* hostName);


				virtual ~NodeImpl();

			   /**
				 * Is this controller connected to this node
				 */
				bool isConnected(int port);

				/**
				 * Attempt to connect to this node.
				 */
				AgentController* connect(int port);


				/**
				 * Attempt to connect to this node.
				 */
				AgentController* connect(ConnectionInfo* connInfo);

				/**
				 * Attempt to connect to this node.
				 */
				AgentController* connect(ConnectionInfo* connInfo, User* user);

				/**
				 * Attempt to connect to this node.
				 */
				void disconnect(int port);

				/**
				 * Retrieve the connection associated with this node object
				 */
				//IConnection* getConnection();
				/**
				 * Retrieve the InetAddress for this Node.
				 */
				char* getInetAddress();


				/**
				 * Retrieve the host name for this Node.
				 */
				char* getName();

				/**
				 * Retrieve the host name for this Node.
				 */
				void setName(char* hostname);


				AgentController* getAC(int port);

		};

	}

}



#endif


