/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation, IBM.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation (Based on the Java
 *                                API implementation by IBM)
 *
 * $Id: ProcessImpl.h,v 1.9 2006/02/10 19:54:16 vnaikawadi Exp $
 *
 *******************************************************************************/



#ifndef  ProcessImpl_H
#define  ProcessImpl_H

#include "tptp/client/IProcess.h"
#include "tptp/client/INode.h"
#include "tptp/client/AgentController.h"
#include "tptp/client/ProcessInfo.h"
#include "tptp/client/Agent.h"
#include "tptp/client/EnvVariable.h"
#include "tptp/client/ICommandHandler.h"
#include "ConsoleImpl.h"

#include <vector>


namespace TPTP
{

	namespace Client
	{

		class PCCommandHandler: public ICommandHandler
		{
			private:
				int responseReceived;				
				CommandElement* responseCommand;
				Semaphore_t responseReceivedSem;
			public:
				PCCommandHandler();
				virtual ~PCCommandHandler();
				void incomingCommand(INode* node, class CommandElement* command);
				int checkResponseReceived();
				CommandElement* getResponseCommand();
				Semaphore_t* getResponseReceivedSem();
		};

		class ProcessImpl: public IProcess
		{
			protected:
					char* 	_name 		;
					//This is the processController AgentID - aka PC ConnectionID
					int 		_destID	;
					INode* 	_node 	;
					AgentController* 	_ac	;
					ConsoleImpl* 	_console ;
					bool 	_isActive ;
					bool 	_isComplt ;
					char*  	_UUID 	;
					char* 	_processId;
					std::vector<ICommandHandler*> 	_listeners;
					std::vector<EnvVariable*> 	_variables;
					int		_srcID	; 
					ProcessInfo* _processInfo;
				
					int _processControllerID;
					
					bool 	_validApp;
					bool	_validWorkingDir;
					
			private:
					//This is being used for the RAC access
					//Need to validate for AC - 
					//Object _launcherLock = new Object();
					//Object _eclipseLock = new Object();
					
					bool _noSuchAliasExceptionThrown ;
					bool _requireEclipseLock;


			public:

				ProcessImpl(AgentController* ac, char* executable=NULL, char* parameters=NULL);

				virtual ~ProcessImpl();
				
				
				void launch();  
				
			
				void kill(); 
				
				
				bool validateProcessToLaunch();
				
				
				void addEventListener(char* interfaceID, ICommandHandler* listener) ;
				
			
				void removeEventListener(char* interfaceID, ICommandHandler* listener); 
				

				
				INode* getNode();

				
				void setName(char* name) ;
				
				
				void setDestID(int destID) ;
				
				
				int getDestID() ;
				
				
				char* getName() ;
				
				
				char* getUUID() ;
				
				
				void setExecutable(char* exe) ; 
				
				
				char* getExecutable();

				
				char* getProcessId() ; 
				
				
				void setProcessId(char* processId);
				
		
				bool isActive() ;
				
				
				IConsole* getConsole() ;
				
				
				void setEnvironmentVariable(char* name, char* value);						

				
				char* getEnvironmentVariable(char* name); 
				
				
				void removeEnvironmentVariable(char* name);
						
				
				//Enumeration getEnvironment() ;
				
			
				void setParameter(char* parameters) ;
				
				
				char* getParameter(); 				

				
				void setLocation(char* location) ; 
				
				
				char* getLocation(); 
				
				
				ProcessInfo* getProcessInfo(); 				

				
				void setProcessInfo(ProcessInfo* pInfo) ;


				/*				
				void prependParameter(char* parameter);
				
				void appendParameter(char* parameter);
				
				void appendEnvironmentVariable(char* name, char* value) ;
				
				void prependEnvironmentVariable(char* name, char* value) ;
				*/
				
				void setSource(int clientSrcID);
				
								

				void connectionClosed(IConnection* connection);


				void processLaunched(IProcess* process);
				
				
				void processExited(IProcess* process) ;
		};


	}

}



#endif

