/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation 
 *
 * $Id: ProcessInfo.cpp,v 1.4 2006/02/10 19:54:16 vnaikawadi Exp $
 *
 *******************************************************************************/



#include "tptp/client/ProcessInfo.h"


using namespace TPTP::Client;



/**
 *  Constructor 
 */
ProcessInfo::ProcessInfo()
{
	this->_processName = 0;
	this->_executable = 0;
	this->_parameters = 0;
	this->_workingDir = 0;
	//this->_envMap.init();
}


/**
 *  Destructor 
 */
ProcessInfo::~ProcessInfo()
{
	
	this->_envMap.clear();
}


/**
 *  Set the Process Name 
 */
void ProcessInfo::setProcessName(char* name)
{
	_processName = name;	
}

/** 
 * get the Process Name 
 */
char* ProcessInfo::getProcessName()
{
	return _processName;
}

/** 
 * Get the Executable name/path 
 */
char* ProcessInfo::getExecutable()
{
	return _executable;
}

/** 
 * Set the Executable name/path 
 */
void ProcessInfo::setExecutable(char* executable)
{
	_executable = executable;
}

/** 
 * Add an environment variable to the process launch config 
 */
void ProcessInfo::addEnvironmentVariable(char* name, char* value)
{
	if (name == NULL) return;

	std::map<char*, char*>::iterator  mapIterator = _envMap.find(name);
	if ((mapIterator == _envMap.end()) && (value != NULL))
	{
		// not found, add the given pair to the table
		_envMap.insert(std::map<char*, char*>::value_type(name, value));
	}
	else
	{
		//TODO modify
		
	}
}

/** 
 * Return the Environment variable name and value 
 */
char* ProcessInfo::getEnvironmentVariable(char* name)
{
	char* envVal = 0;

	if (name == 0) return 0;

	if (_envMap[name] != NULL)
	{
		envVal = _envMap[name];
	}

	return envVal;
}

/** 
 * Remove the environment variable
 */
void ProcessInfo::removeEnvironmentVariable(char* name)
{

   if (name == 0) return;

   std::map<char*, char*>::iterator mapIterator = _envMap.find(name) ;

   if (mapIterator != _envMap.end())
   {
      // delete the pair
      _envMap.erase(mapIterator) ;
   }

   return;
}

/** 
 * Get the process launch environment 
 */
//Hashtable ProcessInfo::getEnvironment()
//{
//	return _environment;
//}

/** 
 * Set the parameters/arguments 
 */
void ProcessInfo::setParameters(char* parameters)
{
	_parameters = parameters;
}

/** 
 * Get the parameters/arguments 
 */
char* ProcessInfo::getParameters()
{
	return _parameters;
}

/** 
 * Set the working directory for launching the process 
 */
void ProcessInfo::setWorkingDirectory(char* location)
{
	_workingDir = location;
}

/** 
 * get the working directory for launching the process 
 */
char* ProcessInfo::getWorkingDirectory()
{
	return _workingDir;
}


