/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM,Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Initial Java API and implementation
 *
 * $Id: TPTP_INetAddress.cpp,v 1.7 2008/05/20 16:52:00 jkubasta Exp $
 *
 *******************************************************************************/ 


#include "tptp/client/TPTP_INetAddress.h"
#include "tptp/NoLog.h"

using namespace std;

#ifdef _WIN32

/* IPV4-ONLY */
int TPTP_INetAddress::getAddress(char* hostname,char** inetaddr)
{
	hostent*  remote_hostname;
	unsigned int remote_hostaddr;
	WSAData wsaData; 
	WSACleanup(); 

	if (WSAStartup(MAKEWORD(2, 2), &wsaData) != 0) 
	{ 
		return -1; 
	} 

	//If the hostname input is char then use getHostbyName else use getHostbyAddr
	if(isalpha(hostname[0]))
	{
		remote_hostname = gethostbyname(hostname);
				
	}
	else
	{
		remote_hostaddr = inet_addr(hostname);
		remote_hostname = gethostbyaddr((char *)&remote_hostaddr, 4, AF_INET);
	}
		
	if (WSAGetLastError() == 0)
	{
		struct in_addr temp;
		memcpy(&temp, remote_hostname->h_addr_list[0],sizeof(struct in_addr));
	
		*inetaddr = inet_ntoa(temp);
	}
	else 
	{
		TPTP_LOG_DEBUG_MSG1("HostAddr / Lookup failed - %d", WSAGetLastError);
		return -1;
	}
	
	WSACleanup(); 

	return 0;
}


#endif

