/*******************************************************************************
 * Copyright (c) 2005 IBM,Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Initial Java API and implementation
 *
 * $Id: TPTP_String.cpp,v 1.5 2005/09/12 18:01:40 akaylor Exp $
 *
 *******************************************************************************/ 


#include "tptp/client/TPTP_String.h"
#include "tptp/NoLog.h"

using namespace std;

TPTP_String::TPTP_String(string data)
{ 
	this->_data = data; 
}

TPTP_String::TPTP_String()
{

}

TPTP_String::~TPTP_String()
{

}

long TPTP_String::length()
{
	return (this->_data).length();
}

void TPTP_String::setData(string data)
{
	this->_data = data;
	//TO DO ArrayCopy
	//UTF-8 Conversion not for this iteration since ASCII --> UTF-8//UNICODE ICU eval
}

string	TPTP_String::getData()
{	
	return this->_data;
}


int	TPTP_String::getSize()
{ 
	return (this->_data).length();
}

int	TPTP_String::getPadding()
{ 
	this->calculatePadding();
	int ret = this->_padding;
	
	return ret;
}



void TPTP_String::calculatePadding()
{ 
	this->_padding = 4 - (this->_data).length()%4;
	if (this->_padding == 4) { this->_padding = 0;}
	TPTP_LOG_DEBUG_MSG1("padding %d", this->_padding);
	 
	return;
}


//TO DO
int TPTP_String::encodeUTF(char	*inputcharset, char** str)
{
	return 0;
}

//TO DO
int TPTP_String::decodeUTF(char	*inputcharset, char** str)
{
	return 0;
}


