/*******************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *
 * $Id: TPTP_XMLHandler.cpp,v 1.8 2009/08/26 14:59:51 jwest Exp $
 *
 *******************************************************************************/ 

#include "tptp/client/TPTP_XMLHandler.h"
#include <stdio.h>

using namespace std;


char *ElementName, *ElementValue;

TPTP_XMLHandler::TPTP_XMLHandler() 
{

}

TPTP_XMLHandler::~TPTP_XMLHandler()
{

}

void TPTP_XMLHandler::endDocument()
{

}

void TPTP_XMLHandler::endElement(const XMLCh* const name)
{
	char *temp = XMLString::transcode(name);
	
	if(ElementName == NULL)
	{	
		if(ElementValue == NULL)
		{
			ElementValue = "\0";
		}
		this->elements.insert(pair<string, string>(temp,ElementValue));
	}
	if(ElementName != NULL)
	{
		if(strcmp(temp, ElementName)==0)
		{ 
			if(!ElementValue)
			{
				ElementValue = "\0";
			}

			this->elements.insert(pair<string, string>(ElementName,ElementValue));
		}
	}
	ElementName = NULL;
	ElementValue = NULL;

	XMLString::release(&temp);
}

void TPTP_XMLHandler::characters(const XMLCh* const chars,
								 const unsigned int length)
{
	char *temp = XMLString::transcode(chars);
	ElementValue = (char *)malloc(strlen(temp)+1);
	strcpy(ElementValue, temp);
	
	XMLString::release(&temp);
	
}

void TPTP_XMLHandler::startDocument()
{

}

void TPTP_XMLHandler::startElement(const XMLCh* const name,
					  			   AttributeList& attributes)
{
	char *temp = XMLString::transcode(name);
	ElementName = (char *)malloc(strlen(temp) +1);
	strcpy(ElementName, temp);
	XMLString::release(&temp);
		
	for (unsigned int index = 0; index < attributes.getLength(); index++) 
	{
		char *name = XMLString::transcode(attributes.getName(index));
		char *value = XMLString::transcode(attributes.getValue(index));
		
		this->attributes.insert(pair<string, string>(name,value));
		XMLString::release(&name);
		XMLString::release(&value);
	}
	

}

void TPTP_XMLHandler::warning(const SAXParseException& exception)
{

}

void TPTP_XMLHandler::error(const SAXParseException& exception)
{
	//printf("Error parsing XML Input. Error occurred at Line Number: %d,Column Number: %d,Error Message is %s\n",exception.getLineNumber(),exception.getColumnNumber(),XMLString::transcode(exception.getMessage()));
		
}

void TPTP_XMLHandler::fatalError(const SAXParseException& exception)
{

}

void TPTP_XMLHandler::notationDecl(	const XMLCh* const name,
									const XMLCh* const publicId,
									const XMLCh* const systemId)
{

}

void TPTP_XMLHandler::unparsedEntityDecl(	const XMLCh* const name,
											const XMLCh* const publicId,
											const XMLCh* const systemId,
											const XMLCh* const notationName)
{

}

string TPTP_XMLHandler::getAgentID(const char *input) 
{

	char	*ID = "test";
	string  agentID;
	
	MemBufInputSource	*stringInputSrc = new MemBufInputSource
	(
		(const XMLByte*)input
		, strlen(input)
		, ID
		, false
	);

	// Set the encoding to EBCDIC from UTF for z-series machines
	#ifdef MVS
			stringInputSrc->setEncoding(XMLUni::fgIBM1047EncodingString);
	#endif

	SAXParser parser;
	
	//parser.setValidationScheme(valScheme);
	parser.setDoNamespaces(false);

    TPTP_XMLHandler *handler = new TPTP_XMLHandler();
	
    parser.setDocumentHandler(handler);
    parser.setErrorHandler(handler);
	
	parser.parse(*stringInputSrc);
	
	for(handler->iter = handler->elements.begin(); handler->iter != handler->elements.end(); handler->iter++)
	{
		if(strcmp(handler->iter->first.c_str(),"AgentID"))
		{ 
		  agentID = handler->iter->second; 
		  break;
		}
	}

    return agentID;
}

void testmain()
{
	string s = TPTP_XMLHandler::getAgentID("<AgentID>Test</AgentID>");
	printf("AgentID =  %s\n",s.c_str());
}



