/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *   
 * $Id: TPTP_XML_Util.cpp,v 1.7 2005/10/28 19:48:50 kcallaghan Exp $
 *
 *******************************************************************************/ 

#include "tptp/TPTPUtils.h"
#include "tptp/NoLog.h"
#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <vector>

using namespace std;


int getAgentID(char *inputXML)
{
	int			sourceID = 0;
	int			context = 0;
	char*		interfaceID = 0;
	char*		cmdName = 0;
	tptp_list_t* paramList;

	int x = parseCommand( inputXML,&sourceID,&context,&interfaceID,&cmdName,&paramList );

	if (x != 0)
	{
		TPTP_LOG_ERROR_MSG("Parse Command Failed."); 
		return -1;
	}
	
	//Get the AgentID from the parsed Command , the token AgentID is hardcoded
	int agentID = -1;
	if (0 != getIntegerParam( "agentID", paramList, &agentID ))
	{
		//cout <<"Error: Command "<<cmdName<<" is missing agentID parameter."<<endl;
	}

	// Free space allocated by parseCommand()
	tptp_free(interfaceID);
	tptp_free(cmdName);
	tptp_list_clear(paramList);
	tptp_free(paramList);
	
	return agentID;
	
}
 


