/*******************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan,Intel - Initial API and implementation
 *
 * $Id: JBaseAgentImpl.cpp,v 1.9 2009/09/10 21:17:40 jcayne Exp $ 
 *******************************************************************************/

#include <iostream>

#include "JBaseAgentImpl.h"

using namespace std;


JBaseAgentImpl::JBaseAgentImpl(char* name) : BaseAgentImpl(name), EventProviderImpl(name), DataProviderImpl(name), VariableProvider(name)
{
	
}


JBaseAgentImpl::~JBaseAgentImpl()
{	
	//TODO: Resource CLean up pending
}

int JBaseAgentImpl::receiveData(int sourceID, char buffer[], int bytesRead, DIME_HEADER_PTR_T dimeHeader)
{
	int ret =receiveDataCallBk(sourceID,buffer,bytesRead,dimeHeader);
	return ret;
}

int JBaseAgentImpl::processCommand(CmdBlock* cmd)	
{ 
	int ret = -1; 
	
	ret = BaseAgentImpl::processCommand(cmd);
	if(ret == 0){ ret = 0; return ret;}
	//go ahead and process the command
	if (ret != 0) 
	{ 
		ret = processCommandCallBk(cmd);
		//if(ret == -1) return ret;
	}
	if ( isEqualString( cmd->getIID(), "org.eclipse.tptp.dataProvider") ||
		      (isEqualString( cmd->getIID(), "org.eclipse.tptp.agentManager") && 
			   isEqualString( cmd->getCommandName(), "dataConnectionsBound")) )
	{
		ret = processDataProviderCommands(cmd);
		//Capture and log one each ret for shmmem and pipe name 
		if(ret == -2)
		{
			//An error occured - see log
			//TODO:Log Error message
			
			return ret;
		}
		//Capture and log one each ret for shmmem and pipe name 
		if(ret == -2)
		{
			//An error occured - see log
			//TODO:Log Error message
			
			return ret;
		}
		//The command was not processed by the BaseClass and hence forward to the agent call back.
		//TODO: Java agent status flags must be modified
		if(ret == -1)
		{
			ret = processDataProviderCommandsCallBk(cmd);
		}
		
	}
	if (isEqualString( cmd->getIID(), "org.eclipse.tptp.eventProvider") )
	{
		//TODO:Log err
		ret = EventProviderImpl::processEventProviderCommands(cmd);
		if(ret == 0) {ret = 0;return ret;}
		//Client Call Back
		if (ret != 0)
		{
			ret = processEventProviderCommandsCallBk(cmd);
			if(ret == -1) {ret = -1;return ret;}
		}
	}
	
	return ret;
}

void JBaseAgentImpl::waitForTermination()
{
	BaseAgentImpl::waitForTermination();
	
	//CallBack into the Java clean up 
	waitForTerminationCallBk();
}

void JBaseAgentImpl::addClient(tptp_int32 clientID, tptp_clientAccessLevel accessLevel)
{
	addClientCallBk(clientID, accessLevel);
}

void JBaseAgentImpl::removeClient(tptp_int32 clientID)
{
	removeClientCallBk(clientID);
}


