/*******************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan,Intel - Initial API and implementation
 *
 * $Id: JBaseAgentImpl.h,v 1.7 2009/09/10 21:17:40 jcayne Exp $
 *******************************************************************************/ 

#ifndef __JBASEAGENTIMPL_H__
#define __JBASEAGENTIMPL_H__

#include "tptp/TPTPExport.h"
#include "tptp/agents/BaseCollectorImpl.h"
#include "tptp/agents/EventProviderImpl.h"
#include "tptp/agents/DataProviderImpl.h"
#include "BaseAgentJNI.h"
#include "tptp/ACFlags.h"

class JBaseAgentImpl : public virtual BaseAgentImpl, public EventProviderImpl, public DataProviderImpl, public VariableProvider
{

	public:
		//JBaseAgentImpl();
		JBaseAgentImpl(char* name);
		~JBaseAgentImpl();

		int receiveData(int sourceID, char buffer[], int bytesRead, DIME_HEADER_PTR_T dimeHeader);
		int processCommand(CmdBlock* cmd);
		void waitForTermination();

		void addClient(tptp_int32 clientID, tptp_clientAccessLevel accessLevel);
		void removeClient(int clientID);
		//void processCommandLine(int argc, char* argv[]);
		//char* getServiceConfigFile();
};

#endif /* __JBASECOLLECTORIMPL_H__ */

