
################################################################################
#                                       
#  makefile:  JavaBaseAgent  project            
#                                       
# $Id: JavaBaseAgent.make,v 1.1.4.2 2008/12/10 17:14:52 jgwest Exp $ 
################################################################################
#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET         :=  libjavaBaseAgent
TARGETDIR      :=  ../../lib

if [ x$VERSIONNUM = x ]; then export VERSIONNUM=0; fi
if [ x$MINORNUM = x ]; then export MINORNUM=0; fi
if [ x$RELEASENUM = x ]; then export RELEASENUM=0; fi

TARGETLIB      :=  $(TARGET).so
TARGETSONAME   :=  $(TARGETLIB).$(VERSIONNUM)
TARGETREALNAME :=  $(TARGETSONAME).$(MINORNUM).$(RELEASENUM)

#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  ../transport/RACommon ../transport/RASharedMemory ../transport/RASocket . ../../include $(JAVA_HOME)/include $(JAVA_HOME)/include/linux


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
UNAME = $(shell uname -s)
MNAME = $(shell uname -m)

ifeq ($(UNAME), Linux)
	ifeq ($(MNAME), s390x)
		LIBS       :=  dl tptpAgentBase pthread 
	else
		ifeq ($(MNAME), s390)
			LIBS       :=  dl tptpAgentBase pthread 
		else
			LIBS       :=  uuid dl tptpAgentBase pthread 
		endif
	endif
else
	LIBS       :=  uuid dl tptpAgentBase pthread 
endif

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../lib $(JAVA_HOME)/lib $(UUID_LIB_DIR)


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

UNAME = $(shell uname -s)
MNAME = $(shell uname -m)

ifeq ($(UNAME), Linux)
	ifeq ($(MNAME), s390x)
		DEFINES += -D_LINUX_390
	else
		ifeq ($(MNAME), s390)
			DEFINES += -D_LINUX_390
		else
			DEFINES += -D_LINUX_X86
		endif
	endif
endif

CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) -Wall $(OPTIMIZABLE) -fPIC $(addprefix -I,$(INCLUDEDIRS)) $(DEFINES)

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) -shared -Wl,-soname,$(TARGETSONAME) -o $(TARGETDIR)/$(TARGETREALNAME) $(addprefix -L,$(LIBDIRS))

#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  gcc
CXX         :=  $(CC)

SOURCE     :=  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.cpp,%.o,$(SOURCE))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)

default : $(TARGET)

objs : $(OBJS)

clean : 
	$(REMOVEFILE) *.o

veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETLIB)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETSONAME) 
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETREALNAME)

rebuild: veryclean everything

$(TARGET) : $(OBJS) 
	$(CC) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS)) 
	$(CREATELINK) $(TARGETREALNAME)  $(TARGETDIR)/$(TARGETSONAME)
	$(CREATELINK) $(TARGETSONAME)    $(TARGETDIR)/$(TARGETLIB)
