
################################################################################
#                                       
#  makefile:  JavaBaseAgent  project            
#                                       
# $Id: JavaBaseAgent_solaris.make,v 1.3 2009/11/21 22:27:16 jwest Exp $ 
################################################################################

ifeq ($(shell uname -m), i86pc)
	SOLARIS_X86=1
endif

#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET         :=  libjavaBaseAgent
TARGETDIR      :=  ../../lib

if [ x$VERSIONNUM = x ]; then export VERSIONNUM=0; fi
if [ x$MINORNUM = x ]; then export MINORNUM=0; fi
if [ x$RELEASENUM = x ]; then export RELEASENUM=0; fi

TARGETLIB      :=  $(TARGET).so
TARGETSONAME   :=  $(TARGETLIB).$(VERSIONNUM)
TARGETREALNAME :=  $(TARGETSONAME).$(MINORNUM).$(RELEASENUM)

#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  ../transport/RACommon ../transport/RASharedMemory ../transport/RASocket . ../../include $(JAVA_HOME)/include $(JAVA_HOME)/include/solaris


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  uuid dl tptpAgentBase pthread Crun

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../lib $(JAVA_HOME)/lib


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------
DEFINES := -DENW -DSQLUNIX -DSOLARIS -D_REENTRANT -D__suncc42

ifdef SOLARIS_X86
	DEFINES += -D_SOLARISX86 
else
	DEFINES += -D_SOLARIS
endif

CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) $(SIXTYFOURBIT) $(LIBLOCATION) $(OPTIMIZABLE) -xCC -KPIC $(addprefix -I,$(INCLUDEDIRS)) $(DEFINES)

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(SIXTYFOURBIT) $(LIBLOCATION) -G -mt -L../../../lib -o $(TARGETDIR)/$(TARGETREALNAME) $(addprefix -L,$(LIBDIRS))

#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  cc
CXX         :=  CC

SOURCE     :=  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.cpp,%.o,$(SOURCE))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)

default : $(TARGET)

objs : $(OBJS)

clean : 
	$(REMOVEFILE) *.o

veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETLIB)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETSONAME) 
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETREALNAME)

rebuild: veryclean everything

$(TARGET) : $(OBJS) 
	$(CC) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS)) 
	$(CREATELINK) $(TARGETREALNAME)  $(TARGETDIR)/$(TARGETSONAME)
	$(CREATELINK) $(TARGETSONAME)    $(TARGETDIR)/$(TARGETLIB)
