
################################################################################
#                                       
#  makefile:  JavaBaseAgent  project            
#                                       
# $Id: JavaBaseAgent_zos.make,v 1.1 2009/08/26 14:46:16 jwest Exp $ 
################################################################################
#-----------------------------------
#
#   Customizable section
#
#-----------------------------------
TARGET         :=  libjavaBaseAgent
TARGETDIR      :=  ../../lib

ifeq (x$(VERSIONNUM),x)
    export VERSIONNUM=0
endif
ifeq (x$(MINORNUM),x)
    export MINORNUM=0
endif
ifeq (x$(RELEASENUM),x)
    export RELEASENUM=0
endif

TARGETLIB      :=  $(TARGET).so
TARGETSONAME   :=  $(TARGETLIB).$(VERSIONNUM)
TARGETREALNAME :=  $(TARGETSONAME).$(MINORNUM).$(RELEASENUM)

#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  ../transport/RACommon ../transport/RASharedMemory ../transport/RASocket . ../../include $(JAVA_HOME)/include $(JAVA_HOME)/include/linux 


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  ../agents/agentBase/libtptpAgentBase.*.x ../shared/TPTPUtil/libtptpUtils.*.x

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../lib $(JAVA_HOME)/lib


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

CXXFLAGS   :=  $(C_FLAGS) $(DEBUGABLE) $(DEBUGFLAGS) -qflag=i $(OPTIMIZABLE) $(addprefix -I,$(INCLUDEDIRS)) -D_OS390 -D_UNIX03_THREADS -DMVS=1 -D_XOPEN_SOURCE_EXTENDED=1 -D_POSIX_SOURCE -D_UNIX03_SOURCE -W c,$(SIXTYFOURBIT)CSECT,NOLOCALE,LANGLVL\(EXTENDED\),LONGNAME,DLL,EXPORTALL,TARGET\(zOSV1R9\),XPLINK

CFLAGS     :=  $(CXXFLAGS),SSCOMM,RENT

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(DEBUGLIBS) -W l,$(SIXTYFOURBIT)DLL,XPLINK,AMODE=$(AMODEBIT),RMODE=ANY,CALL,REUS=RENT -o $(TARGETDIR)/$(TARGETREALNAME) $(addprefix -L,$(LIBDIRS))

#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  xlc++
CXX         :=  $(CC)

SOURCE     :=  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.cpp,%.o,$(SOURCE))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)

default : $(TARGET)

objs : $(OBJS)

clean : 
	$(REMOVEFILE) *.o *.x *.dbg

veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETLIB)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETSONAME) 
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETREALNAME)

rebuild: veryclean everything

$(TARGET) : $(OBJS) 
	$(CC) $(LINKOPTS) $(OBJS) $(LIBS) 
	$(CREATELINK) $(TARGETREALNAME)  $(TARGETDIR)/$(TARGETSONAME)
	$(CREATELINK) $(TARGETSONAME)    $(TARGETDIR)/$(TARGETLIB)
