/*******************************************************************************
 * Copyright (c) 2005 IBM, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Samson Wai, IBM - Initial implementation
 *    Andy Kaylor, Intel - Refactored code for shared library
 *
 * $Id: TPTPLogFile.cpp,v 1.1 2005/09/12 17:52:55 akaylor Exp $ 
 ******************************************************************************/ 

#include "tptp/TPTPLogUtils.h"
#include "TPTPLogUtilsInternal.h"

tptp_int32 tptp_createLogFile( tptp_string* filename, tptp_filehandle* f )
{
	*f = fopen(filename, "w");
	if (*f == NULL) 
	{
		return TPTP_ERROR_CANNOT_OPEN_LOG_FILE;
	}

	return 0;
}

tptp_int32 tptp_writeToLogFile( tptp_filehandle f, const tptp_string* cbe, tptp_int32* bytesWritten )
{
	if (f == NULL) 
	{
		return TPTP_ERROR_INVALID_FILE_HANDLE;
	}


	*bytesWritten = fprintf( f, "%s\n", cbe );
	fflush( f );

	if ( *bytesWritten < 0 )
	{
		return TPTP_ERROR_WRITING_TO_FILE;
	}

	return 0;
}

tptp_int32 tptp_closeLogFile( tptp_filehandle f )
{
	int rc = fclose( f );

	if ( rc == 0 ) 
	{
		return TPTP_ERROR_CLOSING_LOG_FILE;
	}

	return 0;
}


