/*******************************************************************************
 * Copyright (c) 2005, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial API and Implementation
 *
 * $Id: TPTPLogUtils.cpp,v 1.3 2008/05/20 16:52:04 jkubasta Exp $
 *******************************************************************************/ 


#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <windows.h>
#include <winsock2.h>
#endif

#ifdef _WIN32

// Because we are going to use the function 'gethostname' we need to initialize
//    the WinSock library on Windows.  If this is also done elsewhere it will
//    be redundant here, but if it isn't, 'gethostname' will fail.

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			{
				WSADATA  wsaData;

				WSAStartup( MAKEWORD(2, 2), &wsaData);
			}
			break;

		case DLL_PROCESS_DETACH:
			WSACleanup();
			break;

		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		default:
			break;
    }
    return TRUE;
}

#endif // _WIN32
