/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Samson Wai, IBM - Initial implementation
 *    Andy Kaylor, Intel - Refactored code for shared library
 *    Spundun Bhatt (spundun@gmail.com), with the support and encouragement of the University of Southern California Information Sciences Institute Distributed Scalable Systems Division.
 *
 * $Id: TPTPLogUtilsInternal.h,v 1.6 2009/08/07 03:27:55 jwest Exp $ 
 ******************************************************************************/ 

#ifndef __TPTPLOGUTILSINTERNAL_H__
#define __TPTPLOGUTILSINTERNAL_H__

#include "CommonBaseEvent.h"

#if defined(_WIN32)
	#define CBE_LIBRARY_NAME "CommonBaseEvent.dll"
#elif defined(_HPUX)
	#define CBE_LIBRARY_NAME "libcbe.sl"
#elif defined(__APPLE__)
	#define CBE_LIBRARY_NAME "libcbe.dylib"
#else
	#define CBE_LIBRARY_NAME "libcbe.so"
#endif

/* Function names to be imported */
#define FUNC_CBE_CTOR "hcbe_commonBaseEventConstr"
#define FUNC_CBE_DTOR "hcbe_commonBaseEventDestr"
#define FUNC_CBE_SRC_COMP_CTOR "hcbe_componentIdentificationConstr"
#define FUNC_CBE_GENERATE_GUID "hcbe_generateGUID"
#define FUNC_CBE_GET_CURRENT_TIME "hcbe_getCurrentTimeUTC"
#define FUNC_CBE_TO_XML "hcbe_commonBaseEventToCanonicalXMLString"
#define FUNC_CBE_SITUATION_TYPE_CTOR "hcbe_situationTypeConstr"
#define FUNC_CBE_SITUATION_CTOR "hcbe_situationConstr"

/* Common Base Event creation function types */
typedef struct hcbe_CommonBaseEvent* (*cbeConstructor_t)();
typedef char* (*cbeDestructor_t)(hcbe_CommonBaseEvent*);
typedef struct hcbe_ComponentIdentification* (*cbeCompIdConstructor_t)();
typedef char* (*cbeCompIdDestructor_t)(hcbe_ComponentIdentification*);
typedef struct hcbe_SituationType* (*cbeSituationTypeConstructor_t)(int, int*);
typedef struct hcbe_Situation* (*cbeSituationConstructor_t)();
typedef void (*cbeGenerateGuid_t)(char*);
typedef int (*cbeGetCurrentTime_t)(char*);
typedef int (*cbeToXML_t)(struct hcbe_CommonBaseEvent*, char*, int, int);


#define MAX_CBE_BUFFER     8192

#define CBE_HOSTNAME_SIZE  256
#define CBE_MAX_MSG_SIZE   1024
#define MAX_PIDSTR_SIZE    256
#define MAX_TIDSTR_SIZE    256
#define MAX_INSTIDSTR_SIZE 128
#define MAX_EXECENV_SIZE   256
#define CBE_TIMESTR_SIZE   32
#define CBE_GUIDSTR_SIZE   64

// TODO: Move these to a shared location and use unique values
#define TPTP_ERROR_OUTOFMEMORY              -1 
#define TPTP_ERROR_CBE_LIBRARY_UNAVAILABLE  -1
#define TPTP_ERROR_CANNOT_OPEN_LOG_FILE     -1
#define TPTP_ERROR_CLOSING_LOG_FILE         -1
#define TPTP_ERROR_INVALID_FILE_HANDLE      -1
#define TPTP_ERROR_WRITING_TO_FILE          -1

#endif // __TPTPLOGUTILSINTERNAL_H__ 
