
################################################################################
#                                       
#  makefile:  tptpUtils project         
#                                       
# $Id: TPTPLogUtils_aix.make,v 1.1 2009/07/10 00:11:38 jwest Exp $                                  
################################################################################


#-----------------------------------
#
#   Customizable section
#
#   - The TARGETREALNAME variable specifies the name of the library file
#     that will be generated, this includes a base (TARGETLIB) plus	a 
#     version number plus a minor number plus a release number
#   - The TARGETSONAME variable specifies a file name that has just the
#     library name plus the major version number
#   - The TARGETLIB variable specifies the base library name
#   - The TARGETSONAME and TARGETLIB are generated as symbolic links
#     when the library is built
#
#-----------------------------------
TARGET         :=  libtptpLogUtils
TARGETDIR      :=  ../../../lib

if [ -z $VERSIONNUM ]; then export VERSIONNUM=0; fi
if [ -z $MINORNUM  ]; then export MINORNUM=0; fi
if [ -z $RELEASENUM ]; then export RELEASENUM=0; fi

TARGETLIB      :=  $(TARGET).so
TARGETSONAME   :=  $(TARGETLIB).$(VERSIONNUM)
TARGETREALNAME :=  $(TARGETSONAME).$(MINORNUM).$(RELEASENUM)


#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  ../transport/RACommon ../transport/RASharedMemory ../transport/RASocket . ../../../include ${XERCESC_HOME}/include ${CBE_SDK_HOME}/include /usr/local/include

#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  dl xerces-c pthread

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../lib ${XERCESC_HOME}/lib /usr/local/lib ${UUID_HOME}


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings - qflag in xlc
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC). -qpic in xlc
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library - qmkshrobj in xlc
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) $(DEBUGFLAGS) -qflag=i:i $(SIXTYFOURBIT) $(OPTIMIZABLE) -qpic=large $(addprefix -I,$(INCLUDEDIRS))  -D_AIX

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(DEBUGLIBS) $(MKSHARE) -G $(SIXTYFOURBIT) -o $(TARGETDIR)/$(TARGETREALNAME) $(addprefix -L,$(LIBDIRS))
# -Wl,-soname,$(TARGETSONAME)

#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  xlc_r
CXX         :=  $(CC)

SOURCE     :=  $(wildcard *.c) $(wildcard *.cpp)

OBJS       :=  $(patsubst %.c,%.o,$(patsubst %.cpp,%.o,$(SOURCE)))

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf

#%.o : %.cpp
#	$(CC) $(CXXFLAGS) -qmkshrobj $< -o $@


#-----------------------------------
#   "make" rules
#-----------------------------------

.PHONY : default everything objs clean veryclean rebuild $(TARGET)


default : $(TARGET)


objs : $(OBJS)


clean :
	$(REMOVEFILE) *.o


veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETLIB)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETSONAME)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETREALNAME)


rebuild: veryclean everything


$(TARGET) : $(OBJS)
	$(CC) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS))
	$(CREATELINK) $(TARGETREALNAME)  $(TARGETDIR)/$(TARGETSONAME)
	$(CREATELINK) $(TARGETSONAME)    $(TARGETDIR)/$(TARGETLIB)

