/*******************************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Karla Callaghan, Intel - Initial implementation.
 *
 * $Id: TPTPCmdUtil.c,v 1.7 2009/07/10 00:11:29 jwest Exp $
 *******************************************************************************/ 
#include <stdio.h>
#include <stdlib.h>

#ifndef _WIN32
#include <string.h>
#endif

#include "tptp/TPTPUtils.h"

/*
 * Allocate and initialize a tptp_param_t structure.
 *
 * Returns:
 * Pointer to tptp_param_t if successful.
 * Null if error occurred.
 */
tptp_param_t* initParamT(const char* name, const char* value)
{
	tptp_param_t* param = NULL;

	param = (tptp_param_t*)tptp_malloc( sizeof(tptp_param_t) );
	if ( param == NULL )
	{
		// Report internal memory error.
		return NULL;
	}

	if (name)
	{
		int len = strlen(name) + 1;
		param->name = (char*) tptp_malloc(len);
		memcpy(param->name, name, len);
	}
	else
		param->name = NULL;

	if (value)
	{
		int len = strlen(value) + 1;
		param->value = (char*) tptp_malloc(len);
		memcpy(param->value, value, len);
	}
	else
		param->value = NULL;

	return param;
}


/*
 * Allocate a new tptp_param_t structure and copy contents of
 * the param arg into it.
 *
 * Returns:
 * Pointer to clone's tptp_param_t if successful.
 * Null if error occurred.
 */
tptp_param_t* cloneParamT(const tptp_param_t* param)
{
	tptp_param_t* cloneParam = NULL;

	cloneParam = (tptp_param_t*)tptp_malloc( sizeof(tptp_param_t) );
	if ( cloneParam == NULL )
	{
		/* TODO: Report an internal error */
		//TPTP_LOG_ERROR_MSG("CmdUtil: Error - failed to alloc param obj");
		return NULL;
	}

	if (param->name)
	{
		int len = strlen(param->name) + 1;
		cloneParam->name = (char*) tptp_malloc(len);
		memcpy(cloneParam->name, param->name, len);
	}
	else
		cloneParam->name = NULL;

	if (param->value)
	{
		int len = strlen(param->value) + 1;
		cloneParam->value = (char*) tptp_malloc(len);
		memcpy(cloneParam->value, param->value, len);
	}
	else
		cloneParam->value = NULL;

	return cloneParam;
}

/*
 * Used by the tptp_list utility to get a copy of a tptp_param_t node.
 */
int copyParamNode(const tptp_node_t* node, tptp_node_t* nodeCopy)
{
	tptp_param_t* param = (tptp_param_t*)node->data;
	nodeCopy->data = cloneParamT(param);
	return 0;
}



/*
 * Free any allocated members of a tptp_param_t structure.
 */
void destroyParamT(tptp_param_t* param)
{
	if (param == NULL)
		return;

	if (param->name)
	{
		tptp_free(param->name);
		param->name = NULL;
	}

	if (param->value)
	{
		tptp_free(param->value);
		param->value = NULL;
	}

	tptp_free(param);

	return;
}

/*
 * Used by the tptp_list utility to free contents of a tptp_param_t node in a list.
 */
int destroyParamNode(tptp_node_t* node)
{
	tptp_param_t* param = (tptp_param_t*)node->data;
	destroyParamT(param);
	return 0;
}
