/*******************************************************************************
 * Copyright (c) 2003, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Karla Callaghan, Intel - Initial implementation
 *
 * $Id: TPTPErrorString.c,v 1.12 2010/04/01 18:47:08 jwest Exp $ 
 ******************************************************************************/ 
#include "tptp/TPTPUtils.h"
#include <stdio.h>

#ifndef _WIN32
#include <string.h>
#endif

/* Translate a TPTP Error value into a string.
 * Caller is responsible for freeing the allocated string.
 */
char *tptp_getErrorString(int tptpErrNum) 
{
	char *errStr;
	
	errStr = (char *)tptp_malloc(TPTP_MAX_ERROR_STRLEN);
	
	switch (tptpErrNum) {
		case TPTP_OK:
			strcpy(errStr, "No Error");
			break;
		case TPTP_SYS_UNSPECIFIED_ERR:
			strcpy(errStr, "Unspecified System Error");
			break;
		case TPTP_SYS_PROC_NOT_FOUND:
			strcpy(errStr, "Process Not Found");
			break;
		case TPTP_SYS_ACCESS_DENIED:
			strcpy(errStr, "Access Denied");
			break;
		case TPTP_SYS_INVALID_SIGNAL:
			strcpy(errStr, "Invalid Signal");
			break;
		case TPTP_SYS_INVALID_HANDLE:
			strcpy(errStr, "Invalid Handle");
			break;
		case TPTP_SYS_FILE_NOT_FOUND:
			strcpy(errStr, "File Not Found");
			break;
		case TPTP_SYS_NO_MEM:
			strcpy(errStr, "Out of Memory");
			break;
		case TPTP_SYS_SEMAPHORE_FAILED:
			strcpy(errStr, "Failed to Set Semaphore");
			break;
		case TPTP_CMD_MISSING_ARG:
			strcpy(errStr, "Missing TPTP Command Argument");
			break;
		case TPTP_CMD_UNKNOWN:
			strcpy(errStr, "Unknown TPTP Command");
			break;
		case TPTP_UNEXPECTED_NULL_ARG:
			strcpy(errStr, "Unexpected Null Argument");
			break;
		case TPTP_CMD_BAD_ARG:
			strcpy(errStr, "Badly formed TPTP Command Argument");
			break;			
		case TPTP_INTERFACE_UNKNOWN:
			strcpy( errStr, "The specified interface is not recognized by the target component" );
			break;
		case TPTP_UNABLE_TO_CREATE_NAMED_PIPE:
			strcpy(errStr, "Unable to Create Named Pipe");
			break;
		case TPTP_UNABLE_TO_OPEN_NAMED_PIPE:
			strcpy(errStr, "Unable to Open Named Pipe");
			break;
		case TPTP_UNABLE_TO_READ_FROM_NAMED_PIPE:
			strcpy(errStr, "Unable to Read From Named Pipe");
			break;
		case TPTP_PIPE_HAS_ENDED:
			strcpy(errStr, "Pipe Ended");
			break;
		case TPTP_UNABLE_TO_WRITE_TO_NAMED_PIPE:
			strcpy(errStr, "Unable to Write to Named Pipe");
			break;
		case TPTP_UNABLE_TO_CREATE_SHARED_MEM_KEY:
			strcpy(errStr, "Unable to Create Shared Memory Key");
			break;
		case TPTP_UNABLE_TO_CREATE_SHARED_MEM_BLK:
			strcpy(errStr, "Unable to Create Shared Memory Block");
			break;
		case TPTP_UNABLE_TO_OPEN_SHARED_MEM_BLK:
			strcpy(errStr, "Unable to Open Shared Memory Block");
			break;
		case TPTP_UNABLE_TO_ATTACH_SHARED_MEM_BLK:
			strcpy(errStr, "Unable to Attach Shared Memory Block");
			break;
		case TPTP_PC_UNSPECIFIED_ERR:
			strcpy(errStr, "Unspecified Process Controller Error");
			break;
		case TPTP_PC_UNABLE_TO_MONITOR_PROCESS:
			strcpy(errStr, "Unable to Monitor Process");
			break;
		case TPTP_PC_UNABLE_TO_TERM_CHILD_PROCESSES:
			strcpy(errStr, "Unable to Terminate Child Processes");
			break;
		case TPTP_PC_UNABLE_TO_START_PROCESS:
			strcpy(errStr, "Unable to Start Process");
			break;
		case TPTP_PC_UNABLE_TO_STOP_PROCESS:
			strcpy(errStr, "Unable to Stop Process");
			break;
		case TPTP_PC_UNABLE_TO_ADD_EVENT_LSTNR:
			strcpy(errStr, "Unable to Add Event Listener");
			break;
		case TPTP_PC_EXECUTABLE_NOT_FOUND:
			strcpy(errStr, "File Not Found or Not Executable");
			break;
		case TPTP_PC_FILE_NOT_EXECUTABLE:
			strcpy(errStr, "File is Not Executable");
			break;
		case TPTP_PC_DIR_NOT_FOUND:
			strcpy(errStr, "Directory Not Found");
			break;
		case TPTP_PC_FILE_NOT_A_DIR:
			strcpy(errStr, "File is Not a Directory");
			break;
		case TPTP_PC_DIR_NO_WRITE_ACCESS:
			strcpy(errStr, "Directory Not Writeable");
			break;
		case TPTP_PC_PROC_NOT_FOUND:
			strcpy(errStr, "Process Not Found");
			break;
		case TPTP_PC_PROC_NO_STOP:
			strcpy(errStr, "Insufficient Access to Stop Process");
			break;
		case TPTP_PC_CONSOLE_CONNECT_FAILED:
			strcpy(errStr, "Console Connect Failed");
			break;
		case TPTP_PC_CONSOLE_PIPE_CREATE_FAILED:
			strcpy(errStr, "Console Pipe Create Failed");
			break;
		case TPTP_PC_CONSOLE_PIPE_OPEN_FAILED:
			strcpy(errStr, "Console Pipe Open Failed");
			break;
		case TPTP_PC_START_PROC_LIST_EMPTY:
			strcpy(errStr, "Unexpected Empty List of Processes to Start");
			break;
		case TPTP_PC_OPEN_PROC_FAILED:
			strcpy(errStr, "Unable to Open Process");
			break;
		case TPTP_PC_APP_ALIAS_REQUIRED:
			strcpy(errStr, "Configuration Requires Use of Alias, no alias for");
			break;
		case TPTP_AGENT_CANT_OPEN_AC_COMM:
			strcpy(errStr, "Agent Failed to Open Communication with Agent Controller");
			break;
		case TPTP_AGENT_CANT_WRITE_AC_COMM:
			strcpy(errStr, "Agent Failed Write Communication with Agent Controller");
			break;
		case TPTP_AM_ERROR_LAUNCHING_AGENT:
			strcpy( errStr, "Error launching agent" );
			break;
		case TPTP_AM_AGENT_NOT_FOUND:
			strcpy( errStr, "Agent not found" );
			break;
		case TPTP_AM_AGENT_IS_LOCKED:
			strcpy( errStr, "Agent is locked" );
			break;
		case TPTP_AM_CONTROLLER_ACCESS_DENIED:
			strcpy( errStr, "Controller access denied" );
			break;
		case TPTP_AM_OBSERVER_ACCESS_DENIED:
			strcpy( errStr, "Observer access denied" );
			break;
		case TPTP_AM_AGENT_NOT_REFERENCED:
			strcpy( errStr, "Agent not referenced; only observers may become controllers" );
			break;
		case TPTP_AM_AGENT_NOT_CONTROLLED:
			strcpy( errStr, "Agent not controlled; only controllers may release control" );
			break;
		case TPTP_AM_NO_PROCESS_CONTROLLER:
			strcpy( errStr, "The Process Controller could not be found" );
			break;
		case TPTP_AM_AGENT_LAUNCH_FAILED:
			strcpy( errStr, "The Agent Manager attempted to launch the agent process, but the launch failed." );
			break;
		case TPTP_AM_DATA_CONNECTION_NOT_FOUND:
			strcpy( errStr, "Data connection not found" );
			break;
		case TPTP_AM_DATA_CONNECTION_ALREADY_BOUND:
			strcpy( errStr, "Data conneciton already bound" );
			break;
		case TPTP_AM_DATA_CONNECTIONS_INCOMPATIBLE:
			strcpy( errStr, "Data connections are incompatible" );
			break;
		case TPTP_AM_NO_DATA_RECEIVER:
			strcpy( errStr, "No data receiver specified" );
			break;
		case TPTP_AM_NO_METADATA:
			strcpy( errStr, "No metadata is available for the specified agent" );
			break;
		case TPTP_AM_TL_MISSING_FUNC:
			strcpy( errStr, "A required function was not found in one of the specified transport layers." );
			break;
		case TPTP_AM_TL_MISSING_DESCRIPTOR:
			strcpy( errStr, "A direct data connection was requested, but a data descriptor was not found." );
			break;
		case TPTP_AM_NO_PMI:
			strcpy( errStr, "No peer monitoring information was available." );
			break;
		case TPTP_AM_CANT_CONNECT_TO_PEER:
			strcpy( errStr, "Unable to establish a connection with the peer Agent Controller." );
			break;
		case TPTP_AM_ERR_SENDING_PEER_REQUEST:
			strcpy( errStr, "An error occurred while trying to send the peer monitor request." );
			break;
		case TPTP_AM_NO_PM_TRANSPORT:
			strcpy( errStr, "No transport layer for peer monitoring was found in the configuration files." );
			break;
		case TPTP_AM_ACPATH_NOT_FOUND: /* BUG 307787 */
			strcpy( errStr, "Unable to determine full path to Agent Controller");
			break;
		default:
			strcpy(errStr, "Unknown TPTP Error Code");
			break;
	}
	
	return errStr;
}
