/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Ramesh Vishwanath,Intel - Initial API and implementation
 *
 * $Id: Variable.cpp,v 1.3 2005/10/04 02:38:21 kcallaghan Exp $ 
 *******************************************************************************/ 


/* Variable Class Implementation */

#include "tptp/Variable.h"

#define BUFSIZE 1024

Variable::Variable(){
	this->id = -1;
	this->name = NULL;
	this->description = NULL;
	this->type = 0;
	this->read_access = 000;
	this->write_access = 000;
	this->xsdTypeNameSpace = NULL;
	this->xsdTypeNCName = NULL;
	this->value = NULL;
}

Variable::Variable(int id, char* name, char* description, int type, int read_access, int write_access, char* xsdTypeNameSpace, char* xsdTypeNCName, void *value ){
	this->id = id;
	this->name = name;
	this->description = description;
	this->type = type;
	this->read_access = read_access;
	this->write_access = write_access;
	this->xsdTypeNameSpace = xsdTypeNameSpace;
	this->xsdTypeNCName = xsdTypeNCName;
	this->value = value;

}

//TODO: Need a Variable destructor for all these strings presumably!!!!

int Variable::getID(){
	return this->id;
}

char* Variable::getName(){
	return this->name;
}

char* Variable::getDescription(){
	return this->description;
}

int Variable::getType(){
	return this->type;
}

int Variable::getReadAccess(){
	return this->read_access;
}

int Variable::getWriteAccess(){
	return this->write_access;
}

char* Variable::getNameSpace(){
	return this->xsdTypeNameSpace;
}

char* Variable::getNCName(){
	return this->xsdTypeNCName;
}

void* Variable::getValue()
{
	return this->value;
}

int Variable::setID(int id){
	this->id = id;
	return 0;
}

int Variable::setName(char* name){
	this->name = name;
	return 0;
}

int Variable::setDescription(char* description){
	this->description = description;
	return 0;
}

int Variable::setType(int type){
	this->type = type;
	return 0;
}

int Variable::setReadAccess(int readAccess){
	this->read_access = read_access;
	return 0;
}

int Variable::setWriteAccess(int writeAccess)
{
	this->write_access = write_access;
	return 0;
}

int Variable::setNameSpace(char* xsdTypeNameSpace)
{
	this->xsdTypeNameSpace = xsdTypeNameSpace;
	return 0;
}

int Variable::setNCName(char* xsdTypeNCName){
	this->xsdTypeNCName = xsdTypeNCName;
	return 0;
}

int Variable::setValue(void* value){
	this->value = value;
	return 0;
}

char* Variable::createVariableString(Variable* var)
{
	char* buf = (char*)tptp_malloc(BUFSIZE);

	//create reply string
	/*
	sprintf(buf,"<Variable><ID>%d</ID><Name>%s</Name><Description>%s</Description><Type>%d</Type><Value>%s</Value></Variable>",
				var->getID(), var->getName(), var->getDescription(), var->getType(),
				(char *)var->getValue());
	*/
	/*
	sprintf(buf,"<Variable ID=\"%d\" Name=\"%s\" Description=\"%s\" Type=\"%d\" Value=\"%s\"></Variable>",
				var->getID(), var->getName(), var->getDescription(), var->getType(),
				(char *)var->getValue());
	*/
	/* TODO Currently the parseCommand doesn't support XML tags more than 2 levels 
		Hence removed the <Variable> tag , this needs to be rectified after parseCommand is
		changed to use XML parser
	*/
	sprintf(buf,"<ID>%d</ID><Name>%s</Name><Description>%s</Description><Type>%d</Type><Value>%s</Value>",
				var->getID(), var->getName(), var->getDescription(), var->getType(),
				(char *)var->getValue());
	return buf;
}



