/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Ramesh Vishwanath,Intel - Initial API and implementation
 *
 * $Id: VariableGroup.cpp,v 1.1 2005/08/20 19:27:13 vnaikawadi Exp $ 
 *******************************************************************************/ 


/* Variable Group Implementation */

#include "tptp/VariableGroup.h"

#define BUFSIZE 1024


VariableGroup::VariableGroup(){
	this->id = -1;
	this->name = NULL;
	this->description = NULL;
	tptp_list_init(&varList);
	tptp_list_init(&subGroups);
	//this->variables = NULL;
}

VariableGroup::~VariableGroup(){
	tptp_list_clear(&varList);
	tptp_list_clear(&subGroups);
}
VariableGroup::VariableGroup(int id, char* name, char* description, VariableGroup* subGroup, Variable* variable){

	this->id = id;
	this->name = name;
	this->description = description;
	this->subGroups = subGroups;
	tptp_list_init(&this->varList);
	tptp_list_add(&this->varList, variable);
	tptp_list_init(&this->subGroups);
	tptp_list_add(&this->subGroups, subGroup);
}

int VariableGroup::getID(){
	return this->id;
}

char* VariableGroup::getName(){
	return this->name;
}

char* VariableGroup::getDescription(){
	return this->description;
}

tptp_list_t* VariableGroup::getSubGroups(){
	return &this->subGroups;
}

tptp_list_t* VariableGroup::getVariableList(){
	return &this->varList;
}

Variable* VariableGroup::getVariable(int varID){
	
	tptp_node_t* listNode;
    Variable*	 varNode;
	VariableGroup* varGrpNode = NULL;
	
	listNode=this->varList.head;
	while (listNode != 0){
		varNode = (Variable *)listNode->data;
		if (varNode->getID() == varID)
			break;
		listNode = listNode->next;
	}

	if (listNode!=0)
		return varNode;

	//Search in subgroups
	listNode=this->subGroups.head;
	while (listNode != 0){
		varGrpNode= (VariableGroup *)listNode->data;
		varNode = varGrpNode->getVariable(varID);
		if (varNode != 0)
			return varNode;
		listNode = listNode->next;
	}


	return 0;

}

int VariableGroup::setID(int id){
	this->id = id;
	return 0;
}

int VariableGroup::setName(char* name){
	this->name = name;
	return 0;
}

int VariableGroup::setDescription(char* description){
	this->description = description;
	return 0;
}

int VariableGroup::addSubGroup(VariableGroup* subGroup){
	tptp_list_add(&this->subGroups, subGroup);
	return 0;
}

int VariableGroup::setSubGroup(VariableGroup* subGroup){
	
	int grpID = subGroup->getID();
	tptp_node_t* listNode = this->subGroups.head;
	VariableGroup* tempNode;

	while (listNode != 0){
		tempNode = (VariableGroup *)listNode->data;
		if (grpID == tempNode->getID() ){
			tempNode->setDescription(subGroup->getDescription());
			tempNode->setName(subGroup->getName());
			//Ramesh
			tempNode->setSubGroupList(&subGroup->subGroups);
			tempNode->setVariableList(&subGroup->varList);
			return 0;
		}
		else
			listNode = listNode->next;
	}
	
	return -1;

}

int VariableGroup::addVariable(Variable* varNode){
	tptp_list_add(&this->varList, varNode);
	return 0;
}

int VariableGroup::setSubGroupList(tptp_list_t* list){

	//Ramesh : check
	memcpy((tptp_list_t *)&this->subGroups, list, sizeof(list));
	return 0;
}

int VariableGroup::setVariableList(tptp_list_t* list){
	//Ramesh : check
	memcpy((tptp_list_t *)&this->varList, list, sizeof(list));
	return 0;
}

int VariableGroup::setVariable(Variable* varNode){

	tptp_node_t* listNode = this->varList.head;
	Variable* tempNode;

	while (listNode != 0){
		tempNode = (Variable *)listNode->data;
		//Ramesh : Modify
		if (varNode->getID() == tempNode->getID()){

			tempNode->setDescription(varNode->getDescription());
			tempNode->setName(varNode->getName());
			tempNode->setNameSpace(varNode->getNameSpace());
			tempNode->setNCName(varNode->getNCName());
			tempNode->setReadAccess(varNode->getReadAccess());
			tempNode->setType(varNode->getType());
			tempNode->setValue(varNode->getValue());
			tempNode->setWriteAccess(varNode->getWriteAccess());
			
			return 0;
		}
		else
			listNode = listNode->next;
	}	
	return -1;
}



char* VariableGroup::createVarGroupString(VariableGroup* varGroup)
{
	
	char* buf = (char*)tptp_malloc(BUFSIZE);
    char* subgrp = (char*)tptp_malloc(BUFSIZE);
	char* var = (char*)tptp_malloc(BUFSIZE);
	char* temp = (char*)tptp_malloc(BUFSIZE);
	int mem_count=0;
	tptp_list_t* varList = varGroup->getVariableList();
	tptp_node_t* listNode;
	
	/* Create String for variables in variable group */
	listNode = varList->head;
	while (listNode!=0)	{
		temp = Variable::createVariableString((Variable *)listNode->data);
		memcpy(var+mem_count, temp, strlen(temp));
		mem_count+= strlen(temp);
		listNode = listNode->next;
	}
	var[mem_count]='\0';

	/* Create string for subgroup */
	//Ramesh : bzero temp here
	mem_count = 0;
	varList = varGroup->getSubGroups();
	listNode = varList->head;
	while (listNode!=0) {
		temp=createVarGroupString((VariableGroup*)listNode->data);
		memcpy(subgrp+mem_count, temp, strlen(temp));
		mem_count+= strlen(temp);
		listNode = listNode->next;
	}
	subgrp[mem_count]='\0';

		
	/* Create Final String */
	sprintf(buf,"<VariableGroup><ID>%d</ID><Name>%s</Name><Description>%s</Description>%s<SubGroup>%s</SubGroup></VariableGroup>",
		varGroup->getID(), varGroup->getName(), varGroup->getDescription(), var, subgrp);


	/* Clean Mess */
	tptp_free(temp);
	tptp_free(var);
	tptp_free(subgrp);

	return buf;
		
}




