/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Karla Callaghan, Intel - Brought multi-platform support in from HCLauncher
 *				code which was implemented by IBM
 * IBM Corporation - initial implementation
 *
 * $Id: launcher_md.h,v 1.4 2009/01/12 21:06:52 jkubasta Exp $ 
 *******************************************************************************/ 

#ifndef __LAUNCHER_MD_H__
#define __LAUNCHER_MD_H__

#define MAX_ARGS 64
#define MAX_ENV 512

/* MACRO's to simplify the JNI code. */
#if defined __cplusplus && defined _HPUX
	#define ENV(e) e
	#define ENVPARM(e)
#else
	#define ENV(e) (*e)
	#define ENVPARM(e) e,
#endif

int removeJavaArgsQuote(char **str);

/*
 * Platform-dependent functions
 */
#ifdef _WIN32
PID hc_launchProcess_WIN32(char *exe, char *args, char *location, char *env, RA_HANDLE consoleChild[]);

#elif MVS
PID hc_launchProcess_MVS(char *exe, char *args, char *location, char *env, RA_HANDLE consoleChild[]);

#elif __OS400__
PID hc_launchProcess_OS400(char *exe, char *args, char *location, char *env, RA_HANDLE consoleChild[]);

#else
PID hc_launchProcess_UNIX(char *exe, char *args, char *location, char *env, RA_HANDLE consoleChild[]);

#endif


/*
 * Common functions
 */
void* hc_getEnvironment();
int hc_getEnvironmentVariable(void *env, int offset, char **name, char **value );
int hc_getProcessStatus(PID pid);
int  hc_killProcess(PID pid);
PID   hc_launchProcess(char *exe, char *args, char *location, char *env, RA_HANDLE consoleChild[]);
int   hc_readFile(RA_HANDLE fd, char* buffer, int count);
int   hc_writeFileChar(RA_HANDLE fd, char c);

#endif /* __LAUNCHER_MD_H__ */
