/**********************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RATypes.h,v 1.9 2009/11/21 22:27:16 jwest Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef _RATYPES_H_
#define _RATYPES_H_

/**
  * Platform specific includes.
  */
#ifdef _WIN32										/* Win32 */
	#include <winsock2.h>
	#include <windows.h>
	#include <winbase.h>
#else												/* else */
	#include <string.h>
	#include <pthread.h>
	#include <arpa/inet.h>
	#if defined(__OS400__)  || defined(MVS)
 		#include <stdlib.h>
 		#ifdef MVS
			#include <strings.h> /*  228721 - for 390, strings.h is needed to define bzero() */
		#endif
	#else
		#include <strings.h>
	#endif
#endif

#ifdef _HPUX
	#include <string.h>
	#include <malloc.h>
	#include <unistd.h>
#endif

#if defined(_WIN32)
	#define FILE_PATH_SEPARATOR ';'
	#define FILE_PATH_SEPARATOR_STR ";"
	#define FILE_SEPARATOR '\\'
	#define FILE_SEPARATOR_STR "\\"
#else
	#define FILE_PATH_SEPARATOR ':'
	#define FILE_PATH_SEPARATOR_STR ":"
	#define FILE_SEPARATOR '/'
	#define FILE_SEPARATOR_STR "/"
#endif

#if defined(_WIN32)
	typedef DWORD TID;
	typedef DWORD PID;
	typedef HANDLE RA_HANDLE;
#elif (defined(_SOLARIS) || defined(_SOLARISX86)) && defined(__cplusplus)
	typedef int SOCKET;
	typedef int HANDLE;
	typedef int RA_HANDLE;
	typedef pthread_t TID;
	typedef pid_t PID;
	#ifdef FALSE
		#undef FALSE
	#endif
	#ifdef TRUE
		#undef TRUE
	#endif
	typedef enum BOOL {FALSE, TRUE};
#else
	typedef int SOCKET;
	typedef int HANDLE;
	typedef int RA_HANDLE;
	typedef pthread_t TID;
	typedef pid_t PID;
	#ifdef MVS
		#pragma pack(full)
	#endif

		#ifdef FALSE
			#undef FALSE
		#endif
		#ifdef TRUE
			#undef TRUE
		#endif
		enum _BOOL {FALSE, TRUE};
		typedef enum _BOOL BOOL;

	#ifdef MVS
		#pragma pack(reset)
	#endif
#endif

#if defined(__powerpc64__) || defined(__ia64__) || defined(__x86_64__)  || defined(_LP64) || (defined(__linux__) && defined(__s390x__)) || (defined(__64BIT__) && defined(_AIX)) /* long is 8 bytes, int is 4 bytes in size on 64-bit */
	typedef unsigned int ra_uint_t;
	typedef signed int ra_int_t;
#else
	typedef unsigned long ra_uint_t;
	typedef signed long ra_int_t;
#endif

typedef struct {
	ra_uint_t length;
	char *data;
} ra_string_t;

typedef struct {
	ra_uint_t length;
	void **data;
} ra_array_t;

typedef struct {
	ra_string_t type;
	ra_string_t name;
	ra_string_t value;
} ra_agentConfigEntry_t;

/* The structure of a COMMAND */
typedef struct {
	ra_uint_t tag;								/* COMMAND_ID */
	union {
		struct {
			ra_string_t user;
			ra_string_t passwd;
		}authenticate;							/* AUTHENTICATE */

		struct {
			ra_string_t key;
		}authenticate_successful;				/* AUTHENTICATION_SUCCESSFUL */

		struct {
			ra_uint_t ticket;
		}authenticate_failed;					/* AUTHENTICATION_FAILED */


        struct {
            ra_uint_t flag;
            ra_uint_t securePort;
        }serverSecurityRequirements;            /* RA_SERVER_SECURITY_REQUIREMENTS */

		struct {
			ra_uint_t context;
			ra_uint_t consoleIP;
			ra_uint_t consolePort;
			ra_string_t executable;
			ra_string_t arguments;
			ra_string_t location;
			ra_array_t environment;
			ra_array_t agents;
		}launch_process;						/* LAUNCH_PROCESS*/

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t processUUID;
			ra_string_t executable;
			ra_string_t arguments;
			ra_array_t environment;
		}process_launched;						/* PROCESS_LAUNCHED */

		struct {
			ra_uint_t context;
		}query_process_list;					/* QUERY_PROCESS_LIST */

		struct {
			ra_uint_t context;
			ra_array_t processes;
		}registered_process_list;				/* REGISTERED_PROCESS_LIST */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
		}query_agent_list,						/* QUERY_AGENT_LIST */
		 kill_process,							/* KILL_PROCESS */
		 process_exited;						/* PROCESS_EXITED */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t executable;
			ra_array_t agents;
		}registered_agents_list;				/* REGISTERED_AGENTS_LIST */

		struct {
			ra_uint_t context;
			ra_uint_t  processId;
			ra_string_t agent;
		}register_agent_notification,			/* REGISTER_AGENT_NOTIFICATION */
		 query_agent_details;					/* QUERY_AGENT_DETAILS */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t agent;
		}attach,								/* ATTACH */
		 detach,								/* DETACH */
		 stop_monitor,							/* STOP MONITOR */
		 agent_query_state,						/* AGENT_QUERY_ATTACHED */ /* Bug 54376 */
		 agent_state;							/* AGENT_ATTACHED, AGENT_DETACHED */ /* Bug 54376 */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t agent;
			ra_uint_t ip;
			ra_uint_t port;
		}start_monitor_remote;					/* START_MONITOR_REMOTE */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t agent;
			ra_string_t file;
		}start_monitor_local;					/* START_MONITOR_LOCAL */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t agent;
			ra_string_t type;
			ra_string_t name;
			ra_string_t value;
		}set_nv_pair;							/* SET_NV_PAIR */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t agent;
			ra_string_t message;
		}custom_command;						/* CUSTOM_COMMAND */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t agent;
			ra_uint_t severity;
			ra_string_t messageId;
			ra_string_t message;
		}error_string;							/* ERROR_STRING */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t processUUID;
			ra_string_t agent;
			ra_string_t agentUUID;
			ra_string_t agentType;
		}agent_active,							/* AGENT_ACTIVE */
		 agent_inactive,						/* AGENT_INACTIVE */
		 agent_details;							/* AGENT_DETAILS */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
#if defined __linux__
			ra_uint_t messageProcessId;
#endif
			ra_string_t processUUID;
			ra_string_t agent;
			ra_string_t agentUUID;
			ra_string_t agentType;
			ra_string_t nodeUUID;
		}agent_scoping_information;				/* AGENT_SCOPING_INFORMATION */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t processUUID;
			ra_string_t agent;
			ra_string_t agentUUID;
			ra_string_t agentType;
			ra_string_t nodeUUID;
			ra_array_t  configuration;
		}agent_configuration;					/* AGENT_CONFIGURATION */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t agent;
			ra_string_t node;
			ra_uint_t peerProcessId;
			ra_string_t peerAgent;
			ra_string_t peerNode;
		}agent_request_monitor, 				/* AGENT_REQUEST_ATTACH */
		 controller_request_monitor,			/* CONTROLLER_REQUEST_MONITOR */
		 peer_unreachable;						/* PEER_UNREACHABLE */

		struct {
			ra_uint_t context;
			ra_uint_t processId;
			ra_string_t agent;
			ra_string_t node;
			ra_uint_t peerProcessId;
			ra_string_t peerAgent;
			ra_string_t peerNode;
			ra_uint_t port;						/* Bug 77768 */
			ra_uint_t peerPort;					/* Bug 77768 */
		}agent_request_monitor_port, 			/* AGENT_REQUEST_ATTACH */
		 controller_request_monitor_port;		/* CONTROLLER_REQUEST_MONITOR */

		struct {
			ra_uint_t context;
			ra_string_t name;
			ra_string_t type;
			ra_string_t agentUUID;
		} query_property_list;					/* GET_PROPERTY_LIST */

		struct {
			ra_uint_t context;
			ra_array_t entries;
		} property_list;							/* PROPERTY_LIST */

		struct	{
			ra_uint_t context;
			ra_uint_t operation;
			ra_string_t filename;				/* MANAGE_FILE */
		}manage_file;

		struct	{
			ra_uint_t context;
			ra_uint_t port;
			ra_string_t jobKey;
		}resource_location;

		ra_string_t agentName;

	} info;
} ra_command_t;


typedef struct _command_entry_node {
	ra_command_t *command;
	struct _command_entry_node *next;
	struct _command_entry_node *previous;
} ra_command_list_node_t;

typedef struct {
	ra_command_list_node_t *head;
	ra_command_list_node_t *tail;
	ra_uint_t count;
} ra_command_list_t;


typedef struct {
	ra_uint_t type;
	ra_uint_t ticket;
	ra_uint_t length;
	ra_string_t key;
	ra_command_list_t commands;
} ra_message_t;

#ifndef _AIX
	typedef int	*atomic_p; /* Define an element to be manipulated atomicly */
#endif


#endif /* _RATYPES_H_ */
