/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: java.h,v 1.4 2009/07/10 00:11:30 jwest Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef _JAVA_H_
#define _JAVA_H_

#include <jni.h>
#include "RAComm.h"
#include "RATypes.h"

#ifdef __cplusplus
extern "C" {
#endif

/* JVM creation macros */
#if defined(_HPUX)
	#define ATTACH_THREAD(env) (ra_getJvm())->AttachCurrentThread((void**)&env, NULL)
	#define DETACH_THREAD() (ra_getJvm())->DetachCurrentThread()
#else
	#define ATTACH_THREAD(env) (*ra_getJvm())->AttachCurrentThread(ra_getJvm(),  (void**)&env, NULL)
	#define DETACH_THREAD() (*ra_getJvm())->DetachCurrentThread(ra_getJvm())
#endif

/* JVM interface macros */
#if defined(__cplusplus) && (defined(_HPUX) || defined(__powerpc64__) || defined(_AIX))
	#define ENV(e) e
	#define ENVPARM(e)
	#define ENVPARM1(e)
#else
	#define ENV(e) (*e)
	#define ENVPARM(e) e,
	#define ENVPARM1(e) e
#endif

struct _ra_javaJob;

/* Typedef for out Java job completion listener */
typedef int (ra_javaJobImplementation)(struct _ra_javaJob *job);

typedef struct _ra_javaJob {
	TID threadHandle;
	JNIEnv *env;
} ra_javaJob;


/* Typedef for our JVM creation routine */
typedef jint (JNICALL *ra_CreateJavaVM)(JavaVM**, void**, void*);

#ifdef __OS400__
/* This structure is to be used with AS/400 for pthread creation, so that a function pointer can be passed as a variable pointer. */
typedef struct {
    ra_javaJobImplementation *fcn_ptr;
} fcn_ptr_wrp;
#endif

extern int ra_createJavaVitualMachine(char *dllPath);
extern int ra_createJavaVitualMachineWithClasspath(char *dllPath, char *classpath);
extern int ra_destroyJavaVirtualMachine();
extern JavaVM* ra_getJvm();
extern BOOL ra_isJvmCreated();
extern int ra_submitJavaJob(ra_javaJobImplementation *jobImpl, BOOL asynchronous, TID *tid);
extern int ra_submitJavaJobReuseJVMThread(ra_javaJobImplementation *jobImpl, BOOL asynchronous, TID *tid, JNIEnv *jenv);
extern char* copyJavaStringToNative(JNIEnv *env, jstring str);

/** fndclsid **************************************************************************************
  * This function finds the class ID corresponding to the class name given, taking care of
  * platform-dependent encoding on AS/400 and OS/390.
  *
  * @param env          the environment in which the search is to be performed
  * @param clsname      the name of the class in native encoding
  * @returns the Java class ID corresponding to the requested class if any.
  */
extern jclass fndclsid(JNIEnv *env, char *clsname);


/** getnewstrutf **********************************************************************************
  * This function creates a new UTF8 string using the string given, taking care of platform-
  * dependent encoding on AS/400 and OS/390.
  *
  * @param env  the environment in which the search is to be performed
  * @param str  the content of the string to be created
  * @returns the Java string corresponding to the string given.
  */
extern jstring getnewstrutf(JNIEnv *env, char *str);


/** fndmthdid *************************************************************************************
  * This function finds the method ID corresponding to the method given, taking care of platform-
  * dependent encoding on AS/400 and OS/390.
  *
  * @param env        the environment in which the search is to be performed
  * @param clsid      the class ID to which the method belongs
  * @param mthd       the name of the method in native encoding
  * @param sig        the signature of the method in native encoding
  * @returns the Java method ID corresponding to the requested method if any.
  */
extern jmethodID getmthdid(JNIEnv *env, jclass clsid, char *mthd, char *sig);


#ifdef __cplusplus
}
#endif

#endif /* _JAVA_H_ */
