/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RASharedMemory.h,v 1.4 2007/03/19 03:14:37 rsmith Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 *
 * Source File Name = RASharedMemory.h
 *
 * Descriptive Name = Remote Agent Architecture Shared Memory implementation
 *
 * Function:
 *    Defines:
 *
 * Dependencies:
 *    None
 *
 * Restrictions:
 *    None
 *
 * Change Activity:
 * Defect Date        Who Description
 * ====== =========== === ==============================================
 *        Mar/05/2001 dns Initial drop
 * 171596 Apr/05/2001 dns Changed definition of ra_stopFlushingShm from
 *                        ossRamboAutoFlusherStop to ossRamboStopFlusher
 * 172437 Apr/19/2001 dns Added new API function ra_getShmRealHdl
 * 175248 Jun/01/2001 dns Removed defines for ra_attachToShm and ra_stopFlushingShm
 * 198075 Mar/05/2002 dns Changed ossRamboFlushFD to ossRamboFlushToFD
******************************************************************************/
#ifndef _RASHAREDMEM_H
#define _RASHAREDMEM_H

/* This library provides a shared memory implementation on various platforms.
*/

/* Map Remote Agent types to ossRambo types */

#define ra_shm_handle_t OSSRambo
#define ra_shm_err_t OSSErr

#define RA_DESCRIPTOR_FILE    OSS_RAMBO_DESCRIPTOR_FILE
#define RA_DESCRIPTOR_SOCKET  OSS_RAMBO_DESCRIPTOR_SOCKET

typedef struct {
   int descriptorType;
   int descriptor;
} ra_io_descriptor_t;

/* Type for pointer to data processing routine */
typedef int (*RA_Data_Processing_Routine)(
    void *pData,
    int dataLen,
    void *pArgs
    );

/* Map Remote Agent shared memory routines to ossRambo routines */
#include "ossrambo.h"
#include "ossipcmemory.h"  /* 172437 added this because of new API function */

#define ra_createShm(name, size, handle) ossRamboCreate(name, size, 0, 0, handle, NULL, NULL)
#define ra_destroyShm(handle) ossRamboDestroy(handle)
#define ra_flushShmToFD(handle, fd, type)  ossRamboFlushToFD( handle, fd, type)
#define ra_flushShmToFunc(handle, func, args)  ossRamboFlushToFunc( handle, func, args)
#define ra_writeToShm(handle, message, length) ossRamboMultiSlotCopy(handle, message, length)
/* 172437 added new API function */
#define ra_getShmRealHdl(handle) ossIPCMemGetRealHandle(handle->ipcMemHandle)

#ifdef __cplusplus
#define RASHMEXTERN extern "C"
#else
#define RASHMEXTERN extern
#endif

RASHMEXTERN int ra_getShmAttachCount(ra_shm_handle_t *handle);
RASHMEXTERN ra_shm_err_t ra_setShmAttachCount(ra_shm_handle_t *handle, int count);
RASHMEXTERN ra_shm_err_t ra_stopFlusher(ra_shm_handle_t *handle);

#endif
