
################################################################################
#                                       
#  makefile:  RASharedMemory project  
#                                       
# $Id
################################################################################

ifeq ($(shell uname -m), i86pc)
	SOLARIS_X86=1
endif


#-----------------------------------
#
#   Customizable section
#
#   - The TARGETREALNAME variable specifies the name of the library file
#     that will be generated, this includes a base (TARGETLIB) plus	a 
#     version number plus a minor number plus a release number
#   - The TARGETSONAME variable specifies a file name that has just the
#     library name plus the major version number
#   - The TARGETLIB variable specifies the base library name
#   - The TARGETSONAME and TARGETLIB are generated as symbolic links
#     when the library is built
#
#-----------------------------------
TARGET         :=  libhcclsm
TARGETDIR      :=  ../../../lib

if [ x$VERSIONNUM = x ]; then export VERSIONNUM=0; fi
if [ x$MINORNUM = x ]; then export MINORNUM=0; fi
if [ x$RELEASENUM = x ]; then export RELEASENUM=0; fi

TARGETLIB      :=  $(TARGET).so
TARGETSONAME   :=  $(TARGETLIB).$(VERSIONNUM)
TARGETREALNAME :=  $(TARGETSONAME).$(MINORNUM).$(RELEASENUM)


#-----------------------------------
#   list of additional INCLUDE directories to search headers from
#      (separated by blanks)
#-----------------------------------
INCLUDEDIRS    :=  .  ../../../include  ../RACommon  ../RASocket $(JAVA_HOME)/include $(JAVA_HOME)/include/solaris


#-----------------------------------
#   list of additional libraries to be linked with
#      (separated by blanks)
#-----------------------------------
LIBS       :=  dl hcclco hccls pthread

#-----------------------------------
#   list of additional library directories to search from
#      (separated by blanks)
#-----------------------------------
LIBDIRS    :=  ../../../lib


#-----------------------------------
#
#   Compiler options
#
#      -g       produce debug info
#      -Wall    enable all types of warnings
#      -O3      highest level of code optimization
#      -fPIC    generate position-independent code (PIC).
#               This is required for building shared library.
#      -c       compile only
#
#   Linking options
#
#       -Wl       pass options to linker
#       -shared   produce shared library
#       -L        add the given directory to the search path for libraries
#
#-----------------------------------

DEFINES    := -DSQLUNIX -DENW -DREENTRANT -D_REENTRANT -DCONFIG_X86_CMPXCHG
DEFINES2 := -DENW -DSQLUNIX -DSOLARIS -D_REENTRANT -D__suncc42 

ifdef SOLARIS_X86
	DEFINES2 += -D_SOLARISX86  -D_SOLARIS10 
else
	DEFINES2 += -D_SOLARIS
endif

CFLAGS     :=  $(C_FLAGS) $(DEBUGABLE) $(SIXTYFOURBIT) $(LIBLOCATION) $(OPTIMIZABLE) -xCC -KPIC $(addprefix -I,$(INCLUDEDIRS)) $(DEFINES) $(DEFINES2)

CXXFLAGS   :=  $(CFLAGS)

LINKOPTS   :=  $(L_FLAGS) $(DEBUGABLE) $(SIXTYFOURBIT) $(LIBLOCATION) -G -mt -L../../../lib -o $(TARGETDIR)/$(TARGETREALNAME) $(addprefix -L,$(LIBDIRS))


#-----------------------------------
#   general commands and options
#-----------------------------------

CC          :=  cc
CXX         :=  CC
CPP         :=  CC

SOURCE     :=  $(wildcard *.c)  $(wildcard *.cpp)

OBJS       :=  $(patsubst %.c,%.o,$(patsubst %.cpp,%.o,$(SOURCE))) 

REMOVEFILE :=  rm -f
CREATELINK :=  ln -sf


#-----------------------------------
#   "make" rules
#-----------------------------------

default: all

clean :
	$(REMOVEFILE) *.o

veryclean: clean
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETLIB)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETSONAME)
	$(REMOVEFILE) $(TARGETDIR)/$(TARGETREALNAME)

all:
	CC  $(DEBUGABLE) $(SIXTYFOURBIT)  -xCC -KPIC -I. -I../../../include -I../RACommon -I../RASocket -I$(JAVA_HOME)/include -I$(JAVA_HOME)/include/solaris  $(DEFINES) $(DEFINES2) -c sun_asm.il -o ossdebug.o ossdebug.cpp
	CC  $(DEBUGABLE) $(SIXTYFOURBIT)  -xCC -KPIC -I. -I../../../include -I../RACommon -I../RASocket -I$(JAVA_HOME)/include -I$(JAVA_HOME)/include/solaris  $(DEFINES) $(DEFINES2) -c sun_asm.il -o ossipc.o ossipc.cpp
	CC  $(DEBUGABLE) $(SIXTYFOURBIT)  -xCC -KPIC -I. -I../../../include -I../RACommon -I../RASocket -I$(JAVA_HOME)/include -I$(JAVA_HOME)/include/solaris  $(DEFINES) $(DEFINES2) -c sun_asm.il -o ossipcmemory.o ossipcmemory.cpp
	CC  $(DEBUGABLE) $(SIXTYFOURBIT)  -xCC -KPIC -I. -I../../../include -I../RACommon -I../RASocket -I$(JAVA_HOME)/include -I$(JAVA_HOME)/include/solaris $(DEFINES) $(DEFINES2) -c sun_asm.il -o ossmemory.o ossmemory.cpp
	CC  $(DEBUGABLE) $(SIXTYFOURBIT)  -xCC -KPIC -I. -I../../../include -I../RACommon -I../RASocket -I$(JAVA_HOME)/include -I$(JAVA_HOME)/include/solaris $(DEFINES) $(DEFINES2) -c sun_asm.il -o ossrambo.o ossrambo.cpp
	CC  $(DEBUGABLE) $(SIXTYFOURBIT)  -xCC -KPIC -I. -I../../../include -I../RACommon -I../RASocket -I$(JAVA_HOME)/include -I$(JAVA_HOME)/include/solaris $(DEFINES) $(DEFINES2) -c sun_asm.il -o ossramboflush.o ossramboflush.cpp
	CC  $(DEBUGABLE) $(SIXTYFOURBIT)  -xCC -KPIC -I. -I../../../include -I../RACommon -I../RASocket -I$(JAVA_HOME)/include -I$(JAVA_HOME)/include/solaris $(DEFINES) $(DEFINES2) -c sun_asm.il -o osstime.o osstime.cpp
	cc  $(DEBUGABLE) $(SIXTYFOURBIT)  -G -mt -L../../../lib sun_asm.il -o ../../../lib/libhcclsm.so.4.5.0 -L../../../lib ossdebug.o ossipc.o ossipcmemory.o ossmemory.o ossrambo.o ossramboflush.o osstime.o  -ldl -lhcclco -lhccls -lpthread 
	#$(CC) $(LINKOPTS) $(OBJS) $(addprefix -l,$(LIBS)) 
	$(CREATELINK) $(TARGETREALNAME)  $(TARGETDIR)/$(TARGETSONAME)
	$(CREATELINK) $(TARGETSONAME)    $(TARGETDIR)/$(TARGETLIB)

