    .code

;**********************************************************************
; Copyright (c) 2005 IBM Corporation and others.
; All rights reserved.   This program and the accompanying materials
; are made available under the terms of the Eclipse Public License v1.0
; which accompanies this distribution, and is available at
; http://www.eclipse.org/legal/epl-v10.html
; $Id: ldcws.s,v 1.3 2005/08/08 19:32:00 akaylor Exp $
; 
; Contributors: 
; IBM - Initial API and implementation
;**********************************************************************


; i = LDCWS(ptr)
;*****************************************************
; LDCW makes the load+clear word instruction available
;****************************************************
    .proc
    .callinfo
    .export LDCWS, entry
LDCWS
#ifdef	__LP64__
    bve     (rp)
#else
    bv     (rp)
#endif
    ldcws  (arg0), ret0
    .procend


; STWSMA(ptr, value)
;*****************************************************************
; STWSMA sets the value of a word used with LDCWS.  This is necessary
;   on certain PA-90 machines and should work on all PAxx.
;*********************************************************************
    .proc
    .callinfo
    .export STWSMA, entry
STWSMA
#ifdef	__LP64__
    bve     (rp)
#else
    bv     (rp)
#endif
    stws  arg1, 0(arg0)
    .procend



; LDWSMA(ptr, value)
;*****************************************************************
; LDWSMA sets the value of a word used with LDCWS.  This is necessary
;   on certain PA-90 machines and should work on all PAxx.
;*********************************************************************
    .proc
    .callinfo
    .export LDWSMA, entry
LDWSMA
#ifdef	__LP64__
    bve     (rp)
#else
    bv     (rp)
#endif
    ldws  0(arg0), ret0
    .procend

