/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: oss.h,v 1.12 2009/11/21 22:27:16 jwest Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

/******************************************************************************
   Module Name      = oss.h

   Function = Defines external and constant base defines

   Dependencies = Compiler Options

   Operating System = Common

   Change Activity:
   defect Date        Who Description
   ====== =========== === ==============================================
   xxxxxx mmm/dd/yyyy aha Initial Code Drop
   161881 Nov/30/2000 pj  Various changes.
   163585 Jan/05/2001 jpk Various changes.
   170752 Apr/25/2001 dns Porting changes for MVS
   186134 Mar/01/2002 dns Porting changes for other platforms
                          (MVS, OS400, Linux, AIX, HP, Solaris)

        Last Changed =    02/08/27  12:38:03

*******************************************************************************/
#ifndef OSS_HEADER_INCLUDED
#define OSS_HEADER_INCLUDED

#ifdef ENW
#ifdef __cplusplus
#define SQLEXTERNC extern "C"
#else
#define SQLEXTERNC extern
#endif
#ifdef MVS
#define SQLOS390      /* 186134 */
#endif
#if defined(__linux__) && defined(__i386__)
#define SQLO_INTEL_IA32   /* 186135 */
#elif defined __x86_64__
#define SQLO_INTEL_EM64T   /* 186135 */
#elif defined __ia64__
#define SQLO_INTEL_IA64   /* 186135 */
#endif
#ifdef _SOLARIS
#define SQLSUN   /* 186135 */
#endif

#ifdef _SOLARISX86
#define SQLO_SOLARISX86   /* 186135 */
#endif

#ifdef __OS400__
#define SQL_OS400   /* 187607 */
#endif
#define Sint32 long
#define Sint64 long
typedef unsigned int Nuint;
#if defined SQLWINT /* 230912: removed __OS400__ */
/* 189110 - uintptr_t is now defined on MVS too */
#ifndef _WIN64
typedef unsigned int uintptr_t;
#endif
#elif defined __OS400__
/* uintptr_t has to be pointer type on OS400 */
typedef char *uintptr_t;
#endif
#ifdef SQLWINT
typedef signed int ssize_t;
#elif defined MVS /* Bug 50333 - removed _AIX */
// Removed for z/OS - JC
//ifndef true
//typedef unsigned int bool;
//define true 1
//define false 0
//endif
#endif
typedef unsigned int Uint32;
#if defined(__powerpc64__) || defined(__x86_64__) ||  defined(__ia64__) || defined(_WIN64) || defined(_LP64) || (defined(__linux__) && defined(__s390x__)) || (defined(__64BIT__) && defined(_AIX))
	typedef unsigned long Uint64;
#else
	typedef unsigned int Uint64;      /* 186134 - temporary - needs to be changed for 64-bin machines */
#endif
#define SQLZ_PATH_SEP '\\'
typedef Uint32 sqlo_register ;
typedef sqlo_register sqlo_atomic ;
typedef void * OSSMemRes ;
#else
#include "sqlzextc.h"
#include "sqlotype.h"
#include "sqlzbool.h"
#include "sqlzbase.h"
#include "sqlo.h"
#endif

/*******************************************************************************
 * OSSe interface definitions
 ******************************************************************************/
#define OSS_API
#define OSS_EXTERNC SQLEXTERNC

/*******************************************************************************
 * Type definitions
 ******************************************************************************/
typedef int    OSSUid ;
typedef int    OSSGid ;
typedef Sint32 OSSErr ;

#if 0
/*******************************************************************************
 * Type definitions: For V7.2 OSSE COMPATABLITY ONLY, DO NOT USE IN NEW CODE
 ******************************************************************************/
#define OSSSIZE   size_t
#define OSSOFFSET size_t
#define OSS32BIT  Sint32
#define OSS64BIT  Sint64
#define OSSBOOL   bool
#endif

/*******************************************************************************
 * Global resource name
 ******************************************************************************/
#define OSS_RES_NAME          "GLOBALRESOURCE"

/*******************************************************************************
 * Special strings
 ******************************************************************************/
#define OSS_NEWLINE           SQLO_NEWLINE

/*******************************************************************************
 * File system specifics
 ******************************************************************************/
#define OSS_PATH_SEP          SQLZ_PATH_SEP

#endif
