/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ossatomictype.h,v 1.9 2009/04/16 15:29:18 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*******************************************************************************

   Module Name      = ossatomictype.h

   Descriptive Name = OSSe atomic operation types

   Change Activity:
   Defect Date        Who Description
   ====== =========== === ==============================================
   161131 Dec/21/2000 kjs initial drop
   163108 Dec/27/2000 pj  Fix prologue.
   170467 Mar/20/2001 jpk Checked into OSSe
   192160 Oct/23/2001 jpk Make OSSAtomic and OSSRegister the same size
                          on 32- and 64-bit architectures.
   192552 Oct/25/2001 jpk Changed SUN to use 64-bit atomic value
   195525 Nov/20/2001 yka Rename OSSExs to OSSLatch
   186134 Mar/01/2002 dns Added support for other platforms (MVS, OS400, HP, Linux)

   Last Changed =    02/08/27  12:38:07

*******************************************************************************/
#ifndef OSSATOMICTYPE_HEADER_INCLUDED
#define OSSATOMICTYPE_HEADER_INCLUDED

#include "oss.h"


/*******************************************************************************

   IMPORTANT!!!
   Please see the comments in the ossatomic.h header file before making any
   changes to this file.

*******************************************************************************/

#if defined SQLAIXPPC || defined SQLWINT || defined MVS || defined SQLLinux || defined SQL_OS400
	#if defined(__ia64__) || defined(__powerpc64__) || (defined(__linux__) && defined(USE_PTHREAD_ATOMICS))
		#include "osslatch.h" /* Having problems on 64-bit POWER5, do not use atomic func */
	#elif (defined(__linux__) && defined(__s390__))
		#if !defined(USE_GCC_ATOMICS)
			#include "osslatch.h"
		#else
			#define OSS_ATOMIC_USE_PLATFORM_INSTRUCTIONS
		#endif
	#else
		#define OSS_ATOMIC_USE_PLATFORM_INSTRUCTIONS
	#endif
#else
	#include "osslatch.h"
#endif


/* Explicit and implicit register size types */
#ifdef MVS
typedef Uint32 OSSRegister32 ;
typedef Uint64 OSSRegister64 ;
#else
typedef volatile Uint32 OSSRegister32 ;
typedef volatile Uint64 OSSRegister64 ;
#endif

/*
 * If OSSRegister is used, the type's size and layout will be identical on
 * 32- and 64-bit architectures.
 */
#if defined SQLAIXPPC || defined SQLWINT || defined MVS || defined SQLO_INTEL_IA32 || defined SQLSUN || defined HPUX || (defined(__linux__) && defined(__s390__)) || defined SQL_OS400
#if defined(_WIN64) || (defined(__linux__) && defined(__s390x__))
#define OSS_ATOMIC_VALUE_IS_64BITS
typedef OSSRegister64 OSSRegister ;
#else
#define OSS_ATOMIC_VALUE_IS_32BITS
typedef OSSRegister32 OSSRegister ;
#endif
#else
#define OSS_ATOMIC_VALUE_IS_64BITS
typedef OSSRegister64 OSSRegister ;
#endif


/*
 * ABSTRACT ATOMIC TYPE
 *
 * On platforms without hardware support for atomic operations, we have to
 * use a value and lock/latch combination.
 */

/* Explicit sizes */
#if defined OSS_ATOMIC_USE_PLATFORM_INSTRUCTIONS
typedef OSSRegister32 OSSAtomic32 ;
typedef OSSRegister64 OSSAtomic64 ;
#else
typedef struct OSSAtomic32
{
   OSSRegister32 value ;
   OSSLatch latch ;
} OSSAtomic32 ;

typedef struct OSSAtomic64
{
   OSSRegister64 value ;
   OSSLatch latch ;
} OSSAtomic64 ;
#endif

/*
 * If OSSAtomic is used, the type's size and layout will be identical on
 * 32- and 64-bit architectures.
 */
#if defined OSS_ATOMIC_VALUE_IS_32BITS
typedef OSSAtomic32 OSSAtomic ;
#else
typedef OSSAtomic64 OSSAtomic ;
#endif

#endif
