/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: osserror.h,v 1.4 2007/03/19 03:14:37 rsmith Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

/*******************************************************************************

   Module Name      = osserror.h

   Function = Defines external and constant OSS error codes

   Dependencies = Compiler Options: FIXME: document externally

   Operating System = Common

   Change Activity:
   defect Date        Who Description
   ====== =========== === ==============================================
   xxxxxx mmm/dd/yyyy aha Initial Code Drop
   161881 Nov/30/2000 pj  Various changes.
   161178 Jan/17/2001 aha Add message overflow error/warning

        Last Changed =    02/08/27  12:38:20

*******************************************************************************/
#ifndef OSSERROR_HEADER_INCLUDED
#define OSSERROR_HEADER_INCLUDED

/*******************************************************************************
 * Error Definitions
 ******************************************************************************/
#define OSS_OK                 0

#define OSS_ERR_FAILED         -1
#define OSS_ERR_INVALID        -2
#define OSS_ERR_NOTFOUND       -3
#define OSS_ERR_NOMEMORY       -4
#define OSS_ERR_DUPLICATE      -5
#define OSS_ERR_TIMEOUT        -6
#define OSS_ERR_OVERFLOW       -7

#define OSS_ERR_RAMBO_BASE                   (-500)
#define OSS_ERR_RAMBO_NOT_INIT               (OSS_ERR_RAMBO_BASE-1)
   /* RAMBO handle is not initialized */
#define OSS_ERR_RAMBO_AUTOFLUSHER_ENABLED    (OSS_ERR_RAMBO_BASE-2)
   /* RAMBO autoflusher is already enabled */
#define OSS_ERR_RAMBO_IO_ERROR               (OSS_ERR_RAMBO_BASE-3)
#define OSS_ERR_RAMBO_BUFFER_SIZE            (OSS_ERR_RAMBO_BASE-4)
   /* Invalid RAMBO buffer size */
#define OSS_ERR_RAMBO_BUFFER_NAME            (OSS_ERR_RAMBO_BASE-5)
   /* Invalid RAMBO buffer name */
#define OSS_ERR_RAMBO_PTR                    (OSS_ERR_RAMBO_BASE-6)
   /* Invalid RAMBO buffer pointer */

#define OSS_ERR_IPC_BASE                     (-510)
#define OSS_ERR_IPC_SHMEM_ATTACH_FAILED      (OSS_ERR_IPC_BASE-1)
   /* UNIX shared memory attach failed */
#define OSS_ERR_IPC_SHMEM_GET_FAILED         (OSS_ERR_IPC_BASE-2)
   /* UNIX shared memory attach failed */
#define OSS_ERR_IPC_GET_KEY_FAILED           (OSS_ERR_IPC_BASE-3)
   /* UNIX get key failed */
#define OSS_ERR_IPC_CREATE_MAP_FAILED        (OSS_ERR_IPC_BASE-4)
   /* Windows create file map failed */
#define OSS_ERR_IPC_OPEN_MAP_FAILED          (OSS_ERR_IPC_BASE-5)
   /* Windows open file map failed */
#define OSS_ERR_IPC_MEM_MAP_FAILED           (OSS_ERR_IPC_BASE-6)
   /* Windows memory map failed */
#define OSS_ERR_IPC_NOMEMORY                 (OSS_ERR_IPC_BASE-7)
   /* Could not allocate memory from IPC memory */
#define OSS_ERR_IPC_DUPLICATE                (OSS_ERR_IPC_BASE-8)
   /* Tried to create IPC memory with an ID that already exists */
#define OSS_ERR_IPC_NOTFOUND                 (OSS_ERR_IPC_BASE-9)
   /* Tried to attach to IPC memory with an ID that doesn't exist */
#define OSS_ERR_IPC_SECURITY                 (OSS_ERR_IPC_BASE-10)
   /* Failure because of IPC security problem */
#endif
