/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ossexs.h,v 1.4 2007/03/19 03:14:37 rsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*******************************************************************************

   Module Name      = ossexs.h                      

   Function = Defines external and constant Exclusive Section APIs

   Dependencies =

   Operating System = Common

   Change Activity:
   defect Date        Who Description
   ====== =========== === ==============================================
   xxxxxx mmm/dd/yyyy aha Initial Code Drop
   161881 Nov/30/2000 pj  Various changes.
   170752 Apr/25/2001 dns Porting changes for MVS

        Last Changed =    02/08/27  12:38:25

*******************************************************************************/
#ifndef OSSEXS_HEADER_INCLUDED
#define OSSEXS_HEADER_INCLUDED

#include "oss.h"

/* 170752 begin */
#if defined(MVS)
typedef unsigned int OSSExs;
#elif defined(SQLUNIX)
/* 170752 end */
typedef volatile int OSSExs;
#else
typedef volatile unsigned char OSSExs;
#endif

/*******************************************************************************

   Exclusive Section APIs

 ******************************************************************************/

/*******************************************************************************

   Function Name
      ossExsInit

   Function
      Initialize an exclusive section.  Call this before using the
      exclusive section.

   Inputs
      1. pExs
         Address of an exclusive section object.

 ******************************************************************************/
#ifdef MVS
#define ossExsInit( pExs )  *(pExs)=0
#else
inline void ossExsInit( OSSExs * pExs )
{
   *pExs = 0 ;
}
#endif

/*******************************************************************************

   Function Name
      ossExsEnter

   Function
      Enter exclusive section.

   Inputs
      1. pExs
         Address of an exclusive section object.

 ******************************************************************************/
OSS_EXTERNC void OSS_API ossExsEnter( OSSExs * pExs ) ;

/*******************************************************************************

   Function Name
      ossExsExit

   Function
      Exit exclusive section.

   Inputs
      1. pExs
         Address of an exclusive section object.

 ******************************************************************************/
#ifdef MVS
#define ossExsExit( pExs )  *(pExs)=0
#else
inline void ossExsExit( OSSExs * pExs )
{
   *pExs = 0 ;
}
#endif

#endif
