/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ossipc.cpp,v 1.4 2007/03/19 03:14:37 rsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*******************************************************************************

   Module Name      = ossipc.C                      

   Function = Defines external and constant IPC APIs

   Dependencies = Compiler Options: FIXME document externally

   Operating System = Common

   Change Activity:
   defect Date        Who Description
   ====== =========== === ==============================================
   xxxxxx mmm/dd/yyyy aha Initial Code Drop
   161881 Nov/30/2000 pj  Various changes.

        Last Changed =    02/08/27  12:38:27

*******************************************************************************/

#ifdef SQLUNIX

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ipc.h>

#include "ossipc.h"
#include "osserror.h"

/* Copyright */
static char *kCBIBMCopyright="(c) Copyright IBM Corporation 2000";

/*******************************************************************************
 * Generate/lookup resource key based on resource name
 ******************************************************************************/
OSS_EXTERNC OSSErr OSS_API ossIPCGetKey(
      key_t * pKey,        /* O: IPC Key */
      char *  pKeyName,    /* I: Resource name */
      int     keyToken,    /* I: Resource token */
      bool    createFlag ) /* I: Create resource if it doesn't exist */
{
   OSSErr osserr = OSS_OK ;
   key_t  key ;
   char   keyPath[1024] ;
   FILE * pKeyFile ;

   /* Build the temporary file name */
   sprintf( keyPath, "/tmp/%s", pKeyName ) ;

   /* Create the temporary file */
   if ( createFlag )
   {
      pKeyFile = fopen( keyPath, "w" ) ;
      if ( NULL != pKeyFile )
         fclose( pKeyFile ) ;
   }

   /* Lookup the file's ftok for shared resource */
   key = ftok( keyPath, keyToken ) ;
   if ( key == -1 )
   {
      osserr = OSS_ERR_FAILED ;
      key = OSS_IPC_COMMONKEY ;
   }

   *pKey = key ;
   return osserr ;
}

#endif
