/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ossipc.h,v 1.4 2007/03/19 03:14:37 rsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*******************************************************************************

   Module Name      = ossipc.h                   

   Function = Defines external and constant IPC APIs / Defines

   Dependencies = Compiler Options: FIXME: document externally

   Operating System = Common

   Change Activity:
   defect Date        Who Description
   ====== =========== === ==============================================
   xxxxxx mmm/dd/yyyy aha Initial Code Drop
   161881 Nov/30/2000 pj  Various changes.
   162041 Dec/04/2000 jpk Fixed NT build problem.

        Last Changed =    02/08/27  12:38:29

*******************************************************************************/
#ifndef OSSIPC_HEADER_INCLUDED
#define OSSIPC_HEADER_INCLUDED

#include "oss.h"

/*******************************************************************************
   Internal OSS type
 ******************************************************************************/
typedef Sint32 OSSMarker;

#ifdef SQLUNIX
/*******************************************************************************
   Common key if none could be generated
 ******************************************************************************/
#define OSS_IPC_COMMONKEY 0x012db210

/*******************************************************************************
   Generate/lookup resource key based on resource name
 ******************************************************************************/
OSS_EXTERNC OSSErr OSS_API ossIPCGetKey(
      key_t * pKey,           /* O: IPC Key */
      char  * pKeyName,       /* I: Resource name */
      int     keyToken,       /* I: Resource token */
      bool    createFlag ) ;  /* I: Create resource if it doesn't exist */

#endif

#endif
