/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ossipcmemory.h,v 1.4 2007/03/19 03:14:37 rsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*******************************************************************************

   Source File Name = ossipcmemory.h 

   Descriptive Name = OSSe IPC memory

   Function:
      Defines:

   Dependencies:
      None

   Restrictions:
      None

   Change Activity:
   Defect Date        Who Description
   ====== =========== === ==============================================
   xxxxxx mmm/dd/yyyy aha Initial Code Drop.
   161881 Nov/30/2000 pj  Various changes.
   162793 Dec/15/2000 pj  Make OSSMemID a 32 bit int again.
   163585 Jan/05/2001 jpk Various changes.
   164413 Jan/17/2001 jpk Added base address parameter.
   172437 Apr/19/2001 dns Added ossIPCMemGetRealHandle declaration
   186134 Mar/01/2002 dns Added ossIPCMemInitResSize declaration
   205955 May/29/2002 dns Added ossIPCMemSetUserCount  and
                          ossIPCMemAttachCount declarations
        Last Changed =    02/08/27  12:38:34

*******************************************************************************/
#ifndef OSSIPCMEMORY_HEADER_INCLUDED
#define OSSIPCMEMORY_HEADER_INCLUDED

#include "oss.h"

typedef Sint32 OSSMemID ;
#ifndef ENW
typedef void * OSSMemRes 1;
#endif

/* 186134 begin */
/*******************************************************************************
   Initialize default IPC resource memory size
 ******************************************************************************/
OSS_EXTERNC void OSS_API ossIPCMemInitResSize( );
/* 186134  end */

/*******************************************************************************
   Lookup default IPC resource memory size
 ******************************************************************************/
OSS_EXTERNC size_t OSS_API ossIPCMemGetResSize(
      const char * pResName ) ;              /* I: Optional resource name */

/*******************************************************************************
   Specify default IPC resource memory size
 ******************************************************************************/
OSS_EXTERNC void OSS_API ossIPCMemSetResSize(
      const char * pResName,                 /* I: Optional resource name */
      size_t       resSize ) ;               /* I: Resource upper size */

/*******************************************************************************
   Create IPC memory resource
 ******************************************************************************/
OSS_EXTERNC OSSErr OSS_API ossIPCMemCreate(
      OSSMemRes  * pMemRes,                  /* O: Resource handle */
      const char * pResName,                 /* I: Optional resource name */
      OSSMemID     memID,                    /* I: Unique memory identifier */
      size_t       fixedSize,                /* I: (Opt) Fixed size */
      size_t       maxBlksSize,              /* I: (Opt) Variable size limit */
	   const void * pBaseAddress ) ;

/*******************************************************************************
   Authorize access to IPC memory resource
 ******************************************************************************/
OSS_EXTERNC OSSErr OSS_API ossIPCMemAuthorize(
      OSSMemRes memRes,                      /* I: Resource handle */
      OSSUid    uid,                         /* I: User ID (OS-specific) */
      OSSGid    gid ) ;                      /* I: Group ID (OS-specific) */

/*******************************************************************************
   Sets IPC memory resource user count
 ******************************************************************************/
OSS_EXTERNC void OSS_API ossIPCMemSetUserCount(
      OSSMemRes memRes,                      /* I: Resource handle */
      int       usercnt ) ;                   /* I: User Count */

/*******************************************************************************
   Get current attach count for IPC memory resource
 ******************************************************************************/
OSS_EXTERNC OSSErr OSS_API ossIPCMemAttachCount(
      OSSMemRes memRes,                      /* I: Resource handle */
      int *     attcnt ) ;                   /* O: Attach Count */

/*******************************************************************************
   Destroy IPC memory resource
 ******************************************************************************/
OSS_EXTERNC OSSErr OSS_API ossIPCMemDestroy( OSSMemRes memRes ) ;

/*******************************************************************************
   Close IPC memory resource
 ******************************************************************************/
OSS_EXTERNC OSSErr OSS_API ossIPCMemClose( OSSMemRes memRes ) ;

/*******************************************************************************
   Attach to IPC memory resource
 ******************************************************************************/
OSS_EXTERNC OSSErr OSS_API ossIPCMemAttach(
      OSSMemRes  * pMemRes,                  /* O: Resource handle */
      const char * pResName,                 /* I: Optional resource name */
      OSSMemID     memID,                    /* I: Unique memory identifier */
	   const void * pBaseAddress ) ;

/*******************************************************************************
   Detach from IPC memory resource
 ******************************************************************************/
OSS_EXTERNC OSSErr OSS_API ossIPCMemDetach( OSSMemRes memRes ) ;

/*******************************************************************************
   Access user-defined IPC memory control block (Lookup user CB)
 ******************************************************************************/
OSS_EXTERNC void * OSS_API ossIPCMemGetFixed( OSSMemRes memRes ) ;

/* 172437 begin */
/*******************************************************************************
   Access real shared memory handle
 ******************************************************************************/
#ifdef SQLWINT
OSS_EXTERNC HANDLE OSS_API ossIPCMemGetRealHandle( OSSMemRes memRes ) ;
#elif SQLUNIX
OSS_EXTERNC int OSS_API ossIPCMemGetRealHandle( OSSMemRes memRes ) ;
#endif
/* 172437 end */


/*******************************************************************************
   Allocate user memory block
 ******************************************************************************/
OSS_EXTERNC OSSErr OSS_API ossIPCMemAllocBlk(
      OSSMemRes memRes,                      /* I: Resource handle */
      size_t    blkSize,                     /* I: Memory block size */
      void **   ppBlkPtr ) ;                 /* O: Allocated block pointer */

/*******************************************************************************
   Free user memory block
 ******************************************************************************/
OSS_EXTERNC void OSS_API ossIPCMemFreeBlk(
      OSSMemRes memRes,                      /* I: Resource handle */
      void *    pBlkPtr ) ;                  /* I: Block pointer */

/*******************************************************************************
   Convert block pointer to offset
 ******************************************************************************/
OSS_EXTERNC size_t OSS_API ossIPCMemBlk2Offset(
      OSSMemRes memRes,                      /* I: Resource handle */
      void *    pBlkPtr ) ;                  /* I: Block pointer */

/*******************************************************************************
   Convert block pointer to offset
 ******************************************************************************/
OSS_EXTERNC void * OSS_API ossIPCMemOffset2Blk(
      OSSMemRes memRes,                      /* I: Resource handle */
      size_t    blkOffset ) ;                /* I: Block offset */

#endif
