/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ossmemory.h,v 1.4 2007/03/19 03:14:37 rsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*******************************************************************************
   Source File Name = ossmemory.h 

   Descriptive Name = OSSe memory sub-allocation

   Function:
      Defines:

   Dependencies:
      None

   Restrictions:
      None

   Change Activity:
   Defect Date        Who Description
   ====== =========== === ==============================================
   xxxxxx mmm/dd/yyyy aha Initial Code Drop
   161881 Nov/30/2000 pj  Various changes.
   164413 Jan/17/2001 jpk Various changes.

        Last Changed =    02/08/27  12:38:41

*******************************************************************************/
#ifndef OSSMEMORY_HEADER_INCLUDED
#define OSSMEMORY_HEADER_INCLUDED

#include "oss.h"

/*******************************************************************************
 * Initialize OSS Memory for Sub-Allocation
 ******************************************************************************/
OSS_EXTERNC void OSS_API ossMemInitialize(
      void   * pMemArea,                        /*  I: Free memory anchor */
      size_t   memSize ) ;                      /*  I: Free memory size */

/*******************************************************************************
 * Sub-Allocate a Block of Memory (pMemArea = 0 -> private memory)
 ******************************************************************************/
OSS_EXTERNC void * OSS_API ossMemAlloc(
      void   * pMemArea,                        /*  I: Free memory anchor */
      size_t   size ) ;                         /*  I: Free memory size */

/*******************************************************************************
 * Free a Sub-Allocated Block of Memory (pMemArea = 0 -> private memory)
 ******************************************************************************/
/* FIXME: very awkward to have to drag the size and "pool" around for free's */
OSS_EXTERNC void OSS_API ossMemFree(
      void   * pMemArea,                        /*  I: Free memory anchor */
      void   * pBlk,                            /*  I: Block to be freed */
      size_t   size ) ;                         /*  I: Block size */

#define ossMemCopy( pDest, pSrc, size )  memcpy( (pDest), (pSrc), (size) )
#define ossMemSet( pDest, chr, size )    memset( (pDest), (chr) , (size) )
#define ossMemMove( pDest, pSrc, size ) memmove( (pDest), (pSrc), (size) )

#endif
