/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: osstime.cpp,v 1.5 2009/08/07 03:27:55 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 * Spundun Bhatt (spundun@gmail.com), with the support and encouragement of the University of Southern California Information Sciences Institute Distributed Scalable Systems Division.
 **********************************************************************/

/*******************************************************************************

   Module Name      = osstime.C                       

   Function = Defines external and constant Time APIs

   Dependencies = Compiler Options: FIXME document externally

   Operating System = Common

   Change Activity:
   defect Date        Who Description
   ====== =========== === ==============================================
   xxxxxx mmm/dd/yyyy aha Initial Code Drop
   161881 Nov/30/2000 pj  Various changes.
   164875 Jan/23/2001 aha Fix the osstime() for the us calculations

        Last Changed =    02/08/27  12:38:43

*******************************************************************************/

///////////////////////////////////////////////////////////////////////////////
// System Includes
///////////////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <stdlib.h>

#ifdef SQLWINT
#include <windows.h>
#elif __APPLE__
#include <unistd.h>
#include <time.h>
#elif SQLUNIX
#include <time.h>
#include <unistd.h>
#include <sys/time.h>

#endif

///////////////////////////////////////////////////////////////////////////////
// OSS Includes
///////////////////////////////////////////////////////////////////////////////
#include "osstime.h"

///////////////////////////////////////////////////////////////////////////////
// Yield timeslice
///////////////////////////////////////////////////////////////////////////////
void OSS_API ossYield()
{
#ifdef SQLWINT
  Sleep(1);
#elif SQLOS2
  DosSleep(1);
#elif __APPLE__
 struct timespec t1;
 struct timespec t2;
 t1.tv_sec=0;
 t1.tv_nsec=900;
 usleep(1);
#elif SQLUNIX
  usleep(1);
#else
#error Undefined operating system
#endif
}


///////////////////////////////////////////////////////////////////////////////
// Sleep for a period of time in msec
///////////////////////////////////////////////////////////////////////////////
void OSS_API ossSleep(OSSTime ms)
{
#ifdef SQLWINT
  Sleep(ms);

#elif SQLOS2
  DosSleep(ms);

#elif SQLUNIX
  long s = ms / 1000;
  long us= (ms - (s * 1000)) * 1000;
  if (0 != s) sleep(s);
  if (0 != us) usleep(us);
#else
#error Undefined operating system
#endif
}
