/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: osstime.h,v 1.4 2007/03/19 03:14:37 rsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*******************************************************************************

   Module Name      = osstime.h                  

   Function = Defines external and constant Time APIs

   Dependencies = Compiler Options: FIXME: document externally

   Operating System = Common

   Change Activity:
   defect Date        Who Description
   ====== =========== === ==============================================
   xxxxxx mmm/dd/yyyy aha Initial Code Drop
   161881 Nov/30/2000 pj  Various changes.

        Last Changed =    02/08/27  12:38:45

*******************************************************************************/
#ifndef OSSTIME_HEADER_INCLUDED
#define OSSTIME_HEADER_INCLUDED

#include "oss.h"

/*******************************************************************************
 * OSS time type.  May change to Sint64 later for 2038 fix.
 ******************************************************************************/
typedef Sint32 OSSTime;

/*******************************************************************************
 * Yield timeslice
 ******************************************************************************/
OSS_EXTERNC
void OSS_API ossYield();

/*******************************************************************************
 * Sleep for a period of time in msec
 ******************************************************************************/
OSS_EXTERNC
void OSS_API ossSleep(OSSTime ms);

#endif
