/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial API and Implementation
 *
 * $Id: AgentCTL.h,v 1.15 2007/05/31 00:50:52 samwai Exp $
 *
 *******************************************************************************/ 

#ifndef __AGENTCTL_H__
#define __AGENTCTL_H__

#include "tptp/compatibility/RACSupport.h"

#ifdef _WIN32
#define RAC_PIPE_NAMESPACE "\\\\.\\pipe\\IBMAC\\"
#else
#define RAC_PIPE_NAMESPACE "/tmp/IBMRAC/"
#endif
#define RAC_MASTER_ADDRESS "ramaster"

#define MAX_PIPE_NAME 256
#define MAX_RETRIES   64 

#define CONNECT_TIMEOUT	60	/* timeout for incoming connections, seconds */
#define FLUSHER_TIMEOUT	4	/* seconds */

typedef struct
{
	HANDLE          serverPipe;
	char            fullPipeName[MAX_PIPE_NAME];
	process_list_t* processList;
	int             agentInUse;
	Semaphore_t     processScrubSem;
	tptp_list_t     processScrubList;
} actl_state_data_t;


/* Functions implemented in ACTLServer.c */
THREAD_USER_FUNC_RET_TYPE serveRequests(LPVOID args);
int waitForConnection(HANDLE *pPipeHandle, tl_state_data_t* stateData); 
int processRecdMsgs(tl_state_data_t* stateData, char *pBuffer, unsigned int bytesReadIn, unsigned int* offset, unsigned int* messageLen);
BOOL processMessage(tl_state_data_t* stateData, ra_message_t *message);
BOOL forwardCommandsToHandlers( tl_state_data_t* stateData, agent_t *agent, ra_message_t *message );
void forwardCommandToAttachedClient( tl_state_data_t* stateData, ra_command_t *command, agent_t *agent );
void processExternalErrorMessage( tl_state_data_t* stateData, ra_command_t *command, agent_t *agent );

typedef struct {
	tl_state_data_t*    stateData;
	mem_map_block_ptr_t memBlock;
	tptp_int32          partnerID;
	agent_t*            agent;
	BOOL                isDataMultiplexed;
	tptp_int32	    flags;
	tptp_int32		fd;
} actl_data_connection_block_t;

/* Error codes used by processRecdMsgs */
#define ACTL_PRM_PARTIAL_MESSAGE   1
#define ACTL_PRM_ERROR_BAD_ARG     -1


#endif /* __AGENTCTL_H__ */
