/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial API and Implementation
 *
 * $Id: AgentCmdHandlers.h,v 1.7 2006/04/19 21:20:25 koleary Exp $
 *
 *******************************************************************************/ 

#ifndef __AGENTCMDHANDLERS_H__
#define __AGENTCMDHANDLERS_H__

tptp_int32 handleTerminateCommand( tl_state_data_t* stateData, agent_t* agent );
tptp_int32 handleNotifyReferenceCommand( tl_state_data_t* stateData, agent_t* agent, tptp_uint32 clientID );
tptp_int32 handleNotifyDereferenceCommand( tl_state_data_t* stateData, agent_t* agent, tptp_uint32 clientID );
tptp_int32 handleEstablishDataPathCommand( tl_state_data_t* stateData, agent_t* agent, tptp_uint32 partnerID, tptp_uint32 flags, tptp_uint32 clientID, tptp_int32 contextID );
tptp_int32 handleDataConnectionsBoundCommand(tl_state_data_t* stateData, agent_t* agent, tptp_int32 contextID );
tptp_int32 handleReleaseDataPathCommand( tl_state_data_t* stateData, agent_t* agent, tptp_uint32 partnerID );
tptp_int32 handleAgentRegistered( tl_state_data_t* stateData, agent_t* agent, const tptp_list_t* propertyList, tptp_string* agentConfigData );
tptp_int32 handleConnectionInfoReceived( tl_state_data_t* stateData, agent_t* agent, tptp_string* ci, tptp_int32 context );
tptp_int32 startMonitor( tl_state_data_t* stateData, agent_t* agent, tptp_int32 contextID );

#endif /* __AGENTCMDHANDLERS_H__ */
