/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial API and Implementation
 *
 * $Id: Connect2AC.h,v 1.11 2006/11/14 17:23:07 akaylor Exp $
 *
 *******************************************************************************/ 

#ifndef __CONNECT2AC_H__
#define __CONNECT2AC_H__

tptp_int32 forwardXmlCommand( tl_state_data_t* stateData, tptp_string* command );
tptp_int32 handleOutgoingMessage( tl_state_data_t* stateData, agent_t* agent, tptp_string* pCmdBlock );
tptp_int32 registerAgent( tl_state_data_t* stateData, agent_t* agent );
tptp_int32 deregisterAgent( tl_state_data_t* stateData, agent_t* agent );
tptp_int32 dataPathEstablished( tl_state_data_t* stateData, agent_t* agent, tptp_uint32 connectionID, tptp_int32 contextID);
tptp_int32 bindDataConnections( tl_state_data_t* stateData, agent_t* agent, tptp_uint32 partnerID, tptp_uint32 flags, tptp_uint32 clientID, tptp_int32 contextID);
BOOL getProcessUUID( tl_state_data_t* stateData, agent_t* agent, PID pid, tptp_string** uuid);
tptp_int32 createLogfile( tl_state_data_t* stateData, agent_t* agent );
tptp_int32 processCommand( tl_state_data_t* stateData, 
                           agent_t*         agent, 
                           tptp_string*     cmd, 
                           tptp_int32       sourceID, 
                           tptp_int32       context, 
                           tptp_string*     interfaceID, 
                           tptp_string*     cmdName, 
                           tptp_list_t*     paramList );
TID startProcessPurgeThread(tl_state_data_t* stateData);

typedef struct
{
	PID       pid;
	agent_t*  agent;
}
tptp_processScrubEntry_t;

/* The following structure from TPTPBaseTL.h provide a pattern that must be used
 *   if the context data is going to be used with the baseTL_startTimeoutThread function:
 *
 *		typedef struct
 *		{
 *			tptp_uint32     contextDataType;
 *			Semaphore_t     completionSemaphore;
 *			tptp_uint32     timeout;
 *			tptp_int32      status;
 *		} generic_wait_context_t;
 *
 *		#define BASETL_STATUS_PENDING 1
 *		#define BASETL_STATUS_TIMEOUT 2
 *
 * Context data that doesn't require a wait semaphore should still begin with the
 *   contextDataType element to allow detection in the error case.
 */

typedef struct {
	tptp_uint32 contextDataType;
	tptp_uint32 clientID;
	tptp_int32  contextID;
} actl_bind_data_context_t;

typedef struct {
	tptp_uint32 contextDataType;
	agent_t*    sourceAgent;
	ra_command_t*  command;
} actl_peer_monitoring_context_t;

typedef struct
{
	tptp_uint32   contextDataType;
	ra_uint_t     agentContext;
} actl_get_proplist_context_t;

typedef struct
{
	tptp_uint32     contextDataType;
	Semaphore_t     completionSemaphore;
	tptp_uint32     timeout;
	tptp_int32      status;
	tptp_int32      port;
} actl_pmi_context_t;

typedef struct
{
	tptp_uint32     contextDataType;
	Semaphore_t     completionSemaphore;
	tptp_uint32     timeout;
	tptp_int32      status;
	tptp_uint32     agentID;
} get_agent_context_t;

typedef struct
{
	tptp_uint32     contextDataType;
	Semaphore_t     completionSemaphore;
	tptp_uint32     timeout;
	tptp_int32      status;
	tptp_string*    metadata;
} get_agent_meta_context_t;

typedef struct
{
	tptp_uint32     contextDataType;
	Semaphore_t     completionSemaphore;
	tptp_uint32     timeout;
	tptp_int32      status;
	tptp_uint32     processID;
	tptp_string*	uuid;
} get_process_uuid_context_t;

/* These values are used in context structures */
#define ACTL_STATUS_PENDING 1
#define ACTL_STATUS_TIMEOUT 2

#define GET_AGENT_CONTEXT_TYPE        1
#define GET_PROCESS_UUID_CONTEXT_TYPE 2
#define BIND_DATA_PATHS_CONTEXT_TYPE  3
#define GET_PROPLIST_CONTEXT_TYPE     4
#define GET_PMI_CONTEXT_TYPE          5
#define REQUEST_MONITOR_CONTEXT_TYPE  6
#define GET_AGENT_META_CONTEXT_TYPE   7

#endif /* __CONNECT2AC_H__ */
