/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM - Brought in from older RAC (by Andy Kaylor)
 *
 * $Id: RACAgentSupport.h,v 1.7 2006/11/14 17:23:07 akaylor Exp $
 *
 *******************************************************************************/ 

#ifndef __RACAGENTSUPPORT_H__
#define __RACAGENTSUPPORT_H__

extern void ra_initializeDataStructures();


/**  Start headless monitoring*************************************************
 *
 */
void ra_startHeadlessMonitor( tl_state_data_t* stateData, agent_t *agent);

/** PROCESS_LIST_CREATE  *******************************************************
  * Allocates the memory required to create a process_list_t with no entries.
  * ie:  The head and tail are NULL
  */
extern process_list_t* ra_processListCreate();

/** PROCESS_CREATE *************************************************************
  * Allocates the memory for a new process_t and appends this process to a
  * specific process list.  The new process_t structure will always be referenced
  * by list->tail->process.
  */
extern process_t* ra_processCreate(process_list_t* list);

/** PROCESS_FIND ***************************************************************
  * Find a process based upon its PID (key) in a specific process list.
  * @returns      NULL  - process is not in the list.
  *           otherwise - the address of the process_t structure
  */
extern process_t* ra_processFind(process_list_t *list,
								 PID processId);

/** AGENT_MAKE_ACTIVE  ********************************************************
  * Moves an agent from the inactive agent list to the active agent list of a
  * specified process.
  */
extern void ra_agentMakeActive(agent_t *agent);

/** AGENT_MAKE_INACTIVE  ********************************************************
  * Moves an agent from the active agent list to the inactive agent list of a
  * specified process.
  */
extern void ra_agentMakeInactive(agent_t *agent);

/** AGENT_CREATE ***************************************************************
  * Allocates the memory for a new agent_t and appends this agent to a
  * specific process.  The new agent_t structure will always be referenced
  * by process->agents->->tail->agent.
  */
extern agent_t* ra_agentCreate(process_t *process,
							   BOOL active);

/** AGENT_FIND_BY_PROCESS  *****************************************************
  * Find a agent based upon its name (key) in a specific process.
  * @returns      NULL  - agent is not associated with the process.
  *           otherwise - the address of the agent_t structure
  */
extern agent_t* ra_agentFindByProcess(process_t *process,
									  ra_string_t *agentName,
									  BOOL active);

/** AGENT_FIND_BY_UUID  ********************************************************
  *
  */
extern agent_t* ra_agentFindByUUID(process_list_t *list,
								  ra_string_t *agentUUID,
								  BOOL active);

/** GET_ACTIVE_PROCESS_LIST  ***************************************************
  * Retrieves the global process list the represents all the processes the 
  * server knows about.
  */
extern process_list_t* ra_getActiveProcessList();


/** SEND_MESSAGE  *************************************************************
  * Sends the message to the agent provided.  
  * AK - Note: The function signature is modified from the RAC code which 
  *               took a connection where we have an agent.
  */
int ra_forwardMessage(ra_message_t *message, agent_t *agent);



/** SEND_MESSAGE  *************************************************************
  * Returns the address of the global node UUID string.  Callers should
  *    not keep this pointer beyond the scope of the calling function
  */
ra_string_t* getNodeUUID();

/**  Get configured ports *****************************************************
 *
 */
extern ra_uint_t ra_getConfiguredServerPort(void);

/** PROCESS_REMOVE **************************************************************
  * Remove an process from a specific process list.
  */
void ra_processDestroy(process_t *process);

#endif /* __RACAGENTSUPPORT_H__ */
