/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial implementation
 *
 * $Id: CCTLLog.h,v 1.1 2005/09/21 19:16:40 akaylor Exp $
 *
 *******************************************************************************/ 

#ifndef __CCTLLOG_H__
#define __CCTLLOG_H__

/*****************************************************************************************************
 *                                                                                                   *
 * To use the log macros in TPTPLog.h, the following must be defined:                                *
 *                                                                                                   *
 *    RESOLVE_LOG_EVENT_FUNC(p)      resolves to a logEvent function pointer                         *
 *    RESOLVE_INITIAL_PARAM(p)       if a parameter is needed before the subcomponent, this macro    *
 *                                     should give that parameter, including the separating comma    *
 *                                     if no such parameter is needed this macro should resolve to   *
 *                                   white space                                                     *
 *    TPTP_LOG_SUBCOMPONENT_NAME(p)  the name of the subcomponent to appear in the log file          *
 *    TPTP_LOG_INSTANCE_ID(p)        an instance ID for the log file                                 *
 *                                                                                                   *
 *****************************************************************************************************/

/* These definitions assume 'p' will point to a cctl_data_t as defined in ClientCTL.h */

#define RESOLVE_LOG_EVENT_FUNC(p)     p->ac.logEvent
#define RESOLVE_INITIAL_PARAM(p)      p->ac.cmo, /* Note: this trailing comma is required */
#define TPTP_LOG_SUBCOMPONENT_NAME(p) "Client Compatibility TL"
#define TPTP_LOG_INSTANCE_ID(p)       p->transportID

/* Do not move this include, it requires the above definitions */
#include "tptp/TPTPLog.h"

#endif /* __CCTLLOG_H__ */

