/*******************************************************************************
 * Copyright (c) 2005, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial API and Implementation
 *
 * $Id: ClientCTL.h,v 1.27 2008/10/10 21:54:49 jcayne Exp $
 *
 *******************************************************************************/ 

#ifndef __CLIENTCTL_H__
#define __CLIENTCTL_H__

#include "tptp/hashtable.h"
#include "tptp/TPTPBaseTL.h"
#include "tptp/compatibility/RACSupport.h"
#include "fileServer.h"
#include "secureServer.h"
#include "tptp/TPTPUtils.h"

#include "tptp/TransportSupport.h" 
// I added the above header file for access to IPv4/IPv6 functions - jwest

typedef struct
{
	// IPV4-ONLY
	SOCKET			sock;
	
	SOCKET *		sockets; // List of servers sockets we are listening on
	tptp_uint32		numSockets; // Number of sockets we are listening on
	socket_accept_t sockAccept; // State of server socket listening struct 
	
	tptp_uint32		port;
	tptp_uint32		filePort;
	tptp_uint32		acProtocolPort;
	tptp_string		*jvm;
	process_list_t	*processList;
	tptp_int32		selfConnectionID;  /* This TL also acts as a client in some circumstances */
	tptp_string		*classpath;
	BOOL            isDataMultiplexed;
	BOOL            isPolling;
	TID             pollingThread;
	BOOL            isJavaUnsecuredFileServer;

	/* Peer monitoring related fields */
	int             usePeerAttachPort;
	int             peerAttachPort;
	int             usePeerAttachAddress;
	unsigned int    peerAttachAddress;	

	/* Security related fields */
	BOOL			securityEnabled;
	tptp_uint32		securedPort;
	tptp_string		*keystore;
	tptp_string		*keystorePassword;
	network_list_t	*network_list;
	tptp_string		*user;
	tptp_string		*userlist;
} cctl_state_data_t;

/* Helper functions */
tptp_int32 startAgentRegistrationListener( tl_state_data_t* stateData );

// TODO: Move this to another header file
typedef enum
{
	CCTL_NATIVE_SOCKET,
	CCTL_JAVA_SOCKET,
	CCTL_SHUTDOWN,
	CCTL_AGENT_LISTENER	
} cctl_connection_type_t;

typedef struct
{
	tl_state_data_t*        stateData;
	tptp_uint32             clientID;
	cctl_connection_type_t  connectionType;
	SOCKET                  sock;    /* Valid only if connectionType is CCTL_NATIVE_SOCKET */
	jobject                 javaObj; /* Valid only if connectionType is CCTL_JAVA_SOCKET   */
	tl_thread_state_t       processingThreadState;
	tptp_list_t             agents; /* The Agents this client is interested in or attached to */
	BOOL					secured;
	BOOL					authenticated;
} client_connection_block_t;

client_connection_block_t* createClientConnectionBlock(SOCKET clientSock, tl_state_data_t* stateData);
void  freeClientConnectionBlock(client_connection_block_t* ccb);

typedef struct
{
	SOCKET                     sock;
	ra_string_t                agentName;
	ra_uint_t                  context;
	PID                        pid;
	client_connection_block_t* ccb;
} client_data_connection_block_t;

/* TODO: Functions implemented in CCTLServer.c */
THREAD_USER_FUNC_RET_TYPE serveRequests(LPVOID args);
tptp_int32 determineCmdContext(client_connection_block_t* ccb, ra_command_t *cmd);

/* Global references */
tl_state_data_t* g_stateDataForJavaCallback;
jobject g_objectSecuredServer;
jobject g_objectSecuredFileServer;

/* Error codes used by processRecdMsgs */
#define CCTL_PRM_PARTIAL_MESSAGE   1
#define CCTL_PRM_ERROR_BAD_ARG     -1


#endif /* __CLIENTCTL_H__ */
