/*******************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial API and Implementation
 *
 * $Id: Connect2AC.h,v 1.21 2009/09/10 21:17:41 jcayne Exp $
 *
 *******************************************************************************/ 

#ifndef __CONNECT2AC_H__
#define __CONNECT2AC_H__

#include "ClientCTL.h"

tptp_int32 forwardXmlCommand( tl_state_data_t* stateData, tptp_string* command );
tptp_int32 handleOutgoingMessage( tl_state_data_t* stateData, client_connection_block_t* ccb, tptp_string* pCmdBlock );
tptp_int32 getAgentByToken(  tl_state_data_t* stateData, client_connection_block_t* ccb, agent_t* agent );
tptp_int32 getAgent(  tl_state_data_t* stateData, client_connection_block_t* ccb, char *agentName, tptp_int32* agentID );
PID startProcess( client_connection_block_t* ccb, 
	ra_string_t *exe,
	ra_string_t *args,
	ra_string_t *location,
	ra_array_t *environment,
	unsigned long remoteConsoleIP,
	unsigned short remoteConsolePort,
	ra_array_t *finalEnvironment,
	SOCKET *consoleSock,
	ra_string_t *uuid);
BOOL killProcess( client_connection_block_t* ccb, PID pid);
tptp_int32 establishDataPath(tl_state_data_t* stateData, client_connection_block_t* ccb, agent_t* agent, tptp_int32 dataConnectionID, tptp_int32 direction );
tptp_int32 releaseDataPath(tl_state_data_t* stateData, client_connection_block_t* ccb, agent_t* agent);
BOOL queryAgentList(client_connection_block_t* ccb, PID pid, tptp_list_t* agentInfoList );
tptp_int32 waitForAgentDataFlush( tl_state_data_t* stateData, agent_t* agent );
tptp_int32 stopAgentDataFlush( tl_state_data_t* stateData, agent_t* agent );
tptp_int32 notifyAgentOfProcessScrub( tl_state_data_t* stateData, agent_t* agent, PID pid );

/* For AC to AC requests */
tptp_int32 translateAndForwardPeerRequestMonitor( tl_state_data_t*           stateData,
                                                  client_connection_block_t* ccb,
                                                  tptp_int32                 context, 
                                                  tptp_string*               peerHost,
                                                  tptp_string*               peerPort,
                                                  tptp_string*               peerAgentName,
                                                  tptp_string*               peerAgentPID,
                                                  tptp_string*               srcAgentName,
                                                  tptp_string*               srcAgentPID );

/* For AC to client requests */
tptp_int32 translateAndForwardRequestMonitor( tl_state_data_t*           stateData,
                                              client_connection_block_t* ccb,
                                              tptp_int32                 context, 
                                              tptp_string*               peerHost,
                                              tptp_string*               peerPort,
                                              tptp_string*               peerAgentName,
                                              tptp_string*               peerAgentPID );

tptp_int32 processCommand( tl_state_data_t* stateData, 
                           client_connection_block_t* ccb, 
                           tptp_string*     cmd, 
                           tptp_int32       sourceID, 
                           tptp_int32       context, 
                           tptp_string*     interfaceID, 
                           tptp_string*     cmdName, 
                           tptp_list_t*     paramList );


/* TODO: It may make sense to move the following definitions */

/* This will be a list of IDs that we use to determine the appropriate
      context data structure to use.  This is particularly important
	  for handling error response */
#define GET_AGENT_CONTEXT_TYPE           1
#define START_PROCESS_CONTEXT_TYPE       2
#define GET_TYPE_CONTEXT_TYPE            3
#define ESTABLISH_DATA_PATH_CONTEXT_TYPE 4
#define GET_AGENT_LIST_CONTEXT_TYPE      5
#define GET_PROPLIST_CONTEXT_TYPE        6
#define WAIT_FOR_FLUSH_CONTEXT_TYPE      7
#define STOP_FLUSH_CONTEXT_TYPE          8


/* The following structure from TPTPBaseTL.h provide a pattern that must be used
 *   if the context data is going to be used with the baseTL_startTimeoutThread function:
 *
 *		typedef struct
 *		{
 *			tptp_uint32     contextDataType;
 *			Semaphore_t     completionSemaphore;
 *			tptp_uint32     timeout;
 *			tptp_int32      status;
 *		} generic_wait_context_t;
 *
 *		#define BASETL_STATUS_PENDING 1
 *		#define BASETL_STATUS_TIMEOUT 2
 */

/* This is the structure of context data for the getAgentByToken call.
      It could be used for other getAgent calls if we want to make them
	  synchronous */
typedef struct
{
	tptp_uint32     contextDataType;
	Semaphore_t     completionSemaphore;
	tptp_uint32     timeout;
	tptp_int32      status;
	tptp_uint32     agentID;
} get_agent_context_t;

typedef struct
{
	tptp_uint32     contextDataType;
	Semaphore_t     completionSemaphore;
	tptp_uint32     timeout;
	tptp_int32      status;
	tptp_uint32     processID;
	tptp_string*	processUUID;
	tptp_int32      finalEnvCount;
	tptp_string*	finalEnv;
} start_process_context_t;

/* This is the structure of context data for the getAgentByToken call.
      It could be used for other getAgent calls if we want to make them
	  synchronous */
typedef struct
{
	tptp_uint32     contextDataType;
	Semaphore_t     completionSemaphore;
	tptp_uint32     timeout;
	tptp_int32      status;
	ra_string_t     agentType;
	ra_string_t     agentUUID;
} get_type_context_t;

typedef struct
{
	tptp_uint32     contextDataType;
	Semaphore_t     completionSemaphore;
	tptp_uint32     timeout;
	tptp_int32      status;
} establish_data_path_context_t;

typedef struct
{
	tptp_uint32     contextDataType;
	Semaphore_t     completionSemaphore;
	tptp_uint32     timeout;
	tptp_int32      status;
	tptp_list_t*    agentInfoList;
} get_agent_list_context_t;

typedef struct
{
	tptp_uint32                contextDataType;
	ra_uint_t                  clientContext;
} get_property_list_context_t;

#endif /* __CONNECT2AC_H__ */
