/*******************************************************************************
 * Copyright (c) 2005, 2008 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM - Brought in from older RAC (by Andy Kaylor)
 *
 * $Id: RACClientSupport.h,v 1.11 2008/06/16 20:58:03 jkubasta Exp $
 *
 *******************************************************************************/ 

#ifndef __RACPROCESSLIST_H__
#define __RACPROCESSLIST_H__

#include "ClientCTL.h"
#include "tptp/compatibility/RACTypes.h"

typedef struct
{
	    tptp_int32 agentID;
	    tptp_string* agentName;
	    tptp_int32 pid;
} agent_info_t;


extern void ra_initializeDataStructures();


/** PROCESS_LIST_CREATE  *******************************************************
  * Allocates the memory required to create a process_list_t with no entries.
  * ie:  The head and tail are NULL
  */
extern process_list_t* ra_processListCreate();

/** PROCESS_CREATE *************************************************************
  * Allocates the memory for a new process_t and appends this process to a
  * specific process list.  The new process_t structure will always be referenced
  * by list->tail->process.
  */
extern process_t* ra_processCreate(process_list_t* list);

/** PROCESS_FIND ***************************************************************
  * Find a process based upon its PID (key) in a specific process list.
  * @returns      NULL  - process is not in the list.
  *           otherwise - the address of the process_t structure
  */
extern process_t* ra_processFind(process_list_t *list,
								 PID processId);

/** AGENT_CREATE ***************************************************************
  * Allocates the memory for a new agent_t and appends this agent to a
  * specific process.  The new agent_t structure will always be referenced
  * by process->agents->->tail->agent.
  */
extern agent_t* ra_agentCreate(process_t *process,
							   BOOL active);

/** AGENT_FIND_BY_PROCESS  *****************************************************
  * Find a agent based upon its name (key) in a specific process.
  * @returns      NULL  - agent is not associated with the process.
  *           otherwise - the address of the agent_t structure
  */
extern agent_t* ra_agentFindByProcess(process_t *process,
									  ra_string_t *agentName,
									  BOOL active);

/** AGENT_FIND_BY_UUID  ********************************************************
  *
  */
extern agent_t* ra_agentFindByUUID(process_list_t *list,
								  ra_string_t *agentUUID,
								  BOOL active);

/** AGENT_FIND_BY_AGENT_ID ******************************************************
  * This is a new function added for compatibiltiy support
  * It locates an agent structure in the process list given a tptp agent ID
  * @returns      NULL  - agent is not in the process list
  *           otherwise - the address of the agent_t structure
  */
extern agent_t* ra_agentFindByAgentID(process_list_t *list, unsigned int agentID );

/** GET_ACTIVE_PROCESS_LIST  ***************************************************
  * Retrieves the global process list the represents all the processes the 
  * server knows about.
  */
extern process_list_t* ra_getActiveProcessList();

/** SEND_MESSAGE  *************************************************************
  * Sends the message to the agent provided.  
  * AK - Note: The function signature is modified from the RAC code which 
  *               took a connection where we have an client connection block.
  */
int ra_forwardMessage( ra_message_t *message, client_connection_block_t *ccb);


/** GET_NODE_UUID *************************************************************
  * Returns the address of the global node UUID string.  Callers should
  *    not keep this pointer beyond the scope of the calling function
  */
ra_string_t* getNodeUUID();


/** CONNECT_AGENT_TO_CLIENT ***************************************************
  * Marks the given agent as being associated with the given client
  * AK - Note: The function signature is modified from the RAC code which 
  *               took a client_t where we have an client_connection_block_t
  */
extern void ra_connectAgentToClient(agent_t *agent,	client_connection_block_t *ccb);

/** DISCONNECT_AGENT_FROM_CLIENT **********************************************
  * Removes the association between the given agent and the given client
  * AK - Note: The function signature is modified from the RAC code which 
  *               took a client_t where we have an client_connection_block_t
  */
extern void ra_disconnectAgentFromClient(agent_t *agent, client_connection_block_t* ccb);


BOOL scrubProcess(process_list_t *model, process_t *process, tl_state_data_t* stateData);

BOOL ra_killProcess(PID processId);

agent_info_t* findAgentInfo(ra_string_t agentName, tptp_list_t* agentInfoList);

BOOL findProcessAndAgent(
	PID pid,
	ra_string_t *agentName,
	BOOL active,
	process_list_t *list,
	agent_t **agent,
	process_t **process);

/** AGENT_MAKE_ACTIVE  ********************************************************
  * Moves an agent from the inactive agent list to the active agent list of a
  * specified process.
  */
extern void ra_agentMakeActive(agent_t *agent);

/** AGENT_MAKE_INACTIVE  ********************************************************
  * Moves an agent from the active agent list to the inactive agent list of a
  * specified process.
  */
extern void ra_agentMakeInactive(agent_t *agent);

/* computes a sockets ip address using getpeername */
int getClientIP(client_connection_block_t* ccb, unsigned char *buffer, int *length);


int getClientIPAddr(client_connection_block_t* ccb, struct sockaddr_storage ** addr);

SOCKET openClientDataSocket(tptp_int32 ip, tptp_int32 port);

SOCKET openClientDataSocketAddr(struct sockaddr_storage *addr, int port);

#endif /* __RACPROCESSLIST_H__ */
